<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/logout', 'HomeController@logout');
Route::get('/', 'HomeController@index')->name('home');

Route::middleware(['auth'])->group(function() {

    Route::prefix("home")->name("home")->group(function () {
        Route::get('/','HomeController@index');
        Route::get('/home', 'HomeController@index')->name('home');
    });

    Route::namespace("Admin")->prefix("admin")->name("admin.")->group(function () {
        Route::get('/users/getData', 'UserController@getData');
        Route::get('/users/changePassword', 'UserController@changePassword');
        Route::get('/users/reset', 'UserController@reset');
        Route::put('/users/{id}/update','UserController@update');
        Route::get('/users/{id}/delete', 'UserController@delete');
        Route::get('/users/{id}/reset', 'UserController@reset');
        Route::get('/users/profile', 'UserController@profile');
        Route::put('/users/updateProfile', 'UserController@updateProfile');
        Route::put('/users/updatePassword', 'UserController@updatePassword');
        Route::resource("/users", "UserController");

        Route::put('/permissions/{id}/update','PermissionController@update');
        Route::get('/permissions/{id}/delete', 'PermissionController@delete');
        Route::get('/permissions/getData', 'PermissionController@getData');
        Route::get('/permissions/getSupportedRights', 'PermissionController@getSupportedRights');
        Route::resource("/permissions", "PermissionController");
        
        Route::get('/roles/{id}/delete', 'RoleController@delete');
        Route::get('/roles/getData', 'RoleController@getData');
        Route::resource("/roles", "RoleController");
    });

    Route::prefix("dropbox")->name("dropbox.")->group(function () {
        Route::get('/','DropboxAccountController@index');
        Route::post('/','DropboxAccountController@store');
        Route::get('/getUsersByRole', 'DropboxAccountController@getUsersByRole');
        Route::get('/getSharedRolesAndUser', 'DropboxAccountController@getSharedRolesAndUser');
        Route::get('/getData', 'DropboxAccountController@getData');
        Route::get('/create', 'DropboxAccountController@create');
        Route::get('/{id}/edit', 'DropboxAccountController@edit');
        Route::get('/{id}/delete', 'DropboxAccountController@delete');
        Route::put('/{id}/update', 'DropboxAccountController@update');
        Route::get('/{id}/files', 'DropboxAccountController@files');
        Route::post('/{id}/createFolder', 'DropboxAccountController@createFolder');
        Route::post('/{id}/uploadFile', 'DropboxAccountController@uploadFile');
        Route::get('/{id}/sharedFiles', 'DropboxAccountController@sharedFiles');
        Route::post('/download', 'DropboxAccountController@download');
        Route::post('/{id}/shareAccess', 'DropboxAccountController@shareAccess');
        Route::get('/{id}', 'DropboxAccountController@show');
        
    });

    Route::prefix("calendar")->name("calendar.")->group(function () {
        Route::get('/', 'CalendarController@index');
        Route::post('/store','CalendarController@store');
        Route::get('/getData', 'CalendarController@getData');
        Route::post('/update', 'CalendarController@update');
        Route::post('/delete', 'CalendarController@delete');
        Route::get('/getCalendarActivity', 'CalendarController@getCalendarActivity');
        Route::get('/getCalendarSharedAccess', 'CalendarController@getCalendarSharedAccess');
    });

    Route::prefix("feedback")->name("feedback.")->group(function () {
        Route::get('/', 'FeedbackController@index');
        Route::get('/create', 'FeedbackController@create');
        Route::resource("/", "FeedbackController");
    });

    Route::prefix("report")->name("report.")->group(function () {
        Route::get('/', 'ReportController@index');
        Route::get('/create', 'ReportController@create');
        Route::get('/feedback', 'ReportController@feedback');
        Route::post('/feedbackExport', 'ReportController@feedbackExport');
        Route::resource("/", "ReportController");

        Route::get('/session', 'ReportController@sessionReport');
        Route::get('/getSessionReport', 'ReportController@getSessionReport');
        Route::post('/export', 'ReportController@export');
    });
});

Route::get('/videos/room/join/{roomName}/{roomId}', 'VideoRoomController@joinRoom');
Route::get('/videos/room/completeRoom/{roomId}', 'VideoRoomController@completeRoom');
Route::get('/videos/checkRoomSession', 'VideoRoomController@checkRoomSession');
Route::get('/videos/test', 'VideoRoomController@smsTest');
Route::get('/videos/storeVideoParticipant', 'VideoRoomController@storeVideoParticipant');
Route::get('/videos/hideVideo', 'VideoRoomController@hideVideo');
Route::get('/videos/checkVideoStatus', 'VideoRoomController@checkVideoStatus');

Route::get("/videos/max", function(){
    return View::make("video.max");
});

Route::get("/videos/thanks", function(){
    return View::make("video.thankyou");
});

Route::get("/videos/close", function(){
    return View::make("video.close");
});


Route::prefix('videos')->middleware(['auth'])->group(function() {
    Route::get('/', "VideoRoomController@index");
    Route::get('/room', "VideoRoomController@room");
    Route::get('/test', "VideoRoomController@smsTest");
    Route::post('/room/createRoom', 'VideoRoomController@createRoom');
    Route::get('/getData', 'VideoRoomController@getData');
    Route::get('/{compositionId}/downloadRecording', 'VideoRoomController@downloadRecording');
});


Route::get('/clear-cache', function() {
    $output = [];
    \Artisan::call('cache:clear', $output);
    dd($output);
});

Route::get('/download-videos', function() {
    $output = [];
    \Artisan::call('command:downloadVideoRecordings', $output);
    dd($output);
});

Route::get('/get-recordings', function() {
    $output = [];
    \Artisan::call('command:getRecordingStatus', $output);
    dd($output);
});

Route::get('/process-pending-emails', function() {
    $output = [];
    \Artisan::call('cron:processEmailOnQueues', $output);
    dd($output);
});

