@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Create Room</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/videos">Videos</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Create New Room</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
<form id="frmCreateRoom" name="frmCreateRoom" role="form" action="{{ url("/videos/room/createRoom") }}"
    enctype="multipart/form-data" method="POST">
    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Send link via options below to Create a Room</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <div class="icheck-material-primary icheck-inline icheck-video-room">
                                <input type="radio" id="inline-radio-mobile" name="inlineradio" checked/>
                                <label for="inline-radio-mobile">Mobile Number</label>
                            </div>
                            <div class="icheck-material-success icheck-inline icheck-video-room">
                                <input type="radio" id="inline-radio-email" name="inlineradio"/>
                                <label for="inline-radio-email">Email Address</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div  id="divRoomMobile"  name="divRoomMobile" class="form-group col-md-6">
                            <label for="inputName">Mobile Number</label>
                            <input type="text" id="mobileNumber" name="mobileNumber" class="form-control"
                                   value="{{ old('mobileNumber') }}"  onblur="isNumber(this);">
                        </div>
                        <div id="divRoomEmail" name="divRoomEmail" class="form-group col-md-6" style="display: none">
                            <label for="inputName">Email Address</label>
                            <input type="text" id="emailAddress" name="emailAddress" class="form-control"
                                   value="{{ old('emailAddress') }}">
                        </div>
                    </div>    
                      
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
    </div>
<div class="row">
        <div class="col-12">
            <a href="/admin/permissions" class="btn btn-secondary">Cancel</a>
            <input type="submit" value="Create new room" class="btn btn-success float-right">
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script>
    $('.icheck-video-room').change(function () {
        var val = $('input[type=radio][name=inlineradio]:checked').attr('id');
        if (val == 'inline-radio-mobile')
        {
            $('#divRoomMobile').show();
            $('#divRoomEmail').hide();
        } else { // email
            $('#divRoomMobile').hide();
            $('#divRoomEmail').show();
        }    
    });
    $('.icheck-video-room').trigger('change');

    $('#frmCreateRoom').on('submit', function() {
        var val = $('input[type=radio][name=inlineradio]:checked').attr('id');
        if (val == 'inline-radio-mobile')
        {
            if($('#mobileNumber').val()=="")
            {
                alert('Mobile number should not be empty');
                return false;
            }
        } else {
            if($('#emailAddress').val()=="")
            {
                alert('Email Address should not be empty');
                return false;
            }
        }
    });
</script>
@endsection