@php
    use Illuminate\Http\Request;
    $url = \Request::url();
@endphp
<!-- Main Sidebar Container -->
<div id="sidebar-wrapper" data-simplebar="" data-simplebar-auto-hide="true">
    <!-- Brand Logo -->
    <div class="brand-logo">
        <img src="{{ asset('assets/images/logo-system.png')}}" class="logo-icon" alt="logo icon">
        <h5 class="logo-text">Strategic Video</h5>
        <div class="close-btn"><i class="zmdi zmdi-close"></i></div>
     </div>

        <!-- Sidebar Menu -->
        <ul class="metismenu" id="menu">
                <li>
                    <a href="/">
                        <div class="parent-icon">
                            <i class='fa fa-dashboard'></i>
                        </div>
                        <div class="menu-title">Dashboard</div>
                    </a>
                </li>
                @if(isset(session('allUserAccesses')['videos']))
                <li>
                    <a href="/videos">
                        <div class="parent-icon">
                            <i class='fa fa-video-camera'></i>
                        </div>
                        <div class="menu-title">Video Management</div>
                    </a>
                </li>
                @endif
                @if(isset(session('allUserAccesses')['reports'])) 
                    <li>
                        <a class="has-arrow" href="javascript:void();">
                            <div class="parent-icon"><i class="zmdi zmdi-chart"></i></div>
                            <div class="menu-title">Reports</div>
                        </a>
                        <ul class="">
                            <li>
                                <a href="{{url('/report/session')}}" class="nav-link {{strpos($url,'session') !== false ? 'active' :''}}">
                                    <i class="fa fa-area-chart"></i>
                                    <p>Sessions</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif
                @if(isset(session('allUserAccesses')['permissions']) || isset(session('allUserAccesses')['users']) || isset(session('allUserAccesses')['roles'])) 
                <li>
                <a class="has-arrow" href="javascript:void();">
                    <div class="parent-icon"><i class="zmdi zmdi-view-dashboard"></i></div>
                    <div class="menu-title">Admin Tools</div>
                  </a>
                <ul class="">
                    @if(isset(session('allUserAccesses')['users']))
                    <li>
                        <a href="{{url('/admin/users')}}" class="nav-link {{strpos($url,'users') !== false ? 'active' :''}}">
                            <i class="fa fa-user"></i>
                            <p>Users</p>
                        </a>
                    </li>
                    @endif
                    @if(isset(session('allUserAccesses')['roles']))
                    <li>
                        <a href="{{url('/admin/roles')}}" class="nav-link {{strpos($url,'roles') !== false ? 'active' :''}}">
                            <i class="fa fa-users"></i>
                            <p>Roles</p>
                        </a>
                    </li>
                    @endif
                    @if(isset(session('allUserAccesses')['permissions']))
                    <li>
                        <a href="{{url('/admin/permissions')}}" class="nav-link {{strpos($url,'permissions') !== false ? 'active' :''}}">
                            <i class="fa fa-cogs"></i>
                            <p>Permissions</p>
                        </a>
                    </li>
                    @endif
                </ul>
                @endif
                </li>
                <li>
                    <a href="/logout">
                        <div class="parent-icon">
                            <i class='fa fa-power-off'></i>
                        </div>
                        <div class="menu-title">Logout</div>
                    </a>
                </li>
        </ul>
        <!-- /.sidebar-menu -->

</div>
