@extends('layouts.app')
@section('content')
<style>
    *{
    margin: 0;
    padding: 0;
}
.rate {
    float: left;
    height: 46px;
    padding: 0 10px;
}
.rate:not(:checked) > input {
    position:absolute;
    top:-9999px;
}
.rate:not(:checked) > label {
    float:right;
    width:1em;
    overflow:hidden;
    white-space:nowrap;
    cursor:pointer;
    font-size:30px;
    color:#ccc;
}
.rate:not(:checked) > label:before {
    content: '★ ';
}
.rate > input:checked ~ label {
    color: #ffc700;    
}
.rate:not(:checked) > label:hover,
.rate:not(:checked) > label:hover ~ label {
    color: #deb217;  
}
.rate > input:checked + label:hover,
.rate > input:checked + label:hover ~ label,
.rate > input:checked ~ label:hover,
.rate > input:checked ~ label:hover ~ label,
.rate > label:hover ~ input:checked ~ label {
    color: #c59b08;
}
</style>
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Feedback Form</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/feedback/">Feedback</a></li>
                    <li class="breadcrumb-item active">Create Feedback</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    
<form id="frmCreateFeedback" name="frmCreateFeedback" role="form" action="{{ url("/feedback/") }}"
    enctype="multipart/form-data" method="POST">
    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Survey</h3>

                
                </div>
                <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="inputStatus">System</label>
                                <select id="system"  name="system" class="form-control custom-select">
                                    @foreach($systems as $system)
                                        <option value="{{$system->description}}">{{$system->description}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="inputName">Overall Review</label>
                                <div class="form-group col-md-12">
                                    
                                    <div class="rate">
                                        <input type="radio" id="star5" name="overAllReview" value="5" />
                                        <label for="star5" title="text">5 stars</label>
                                        <input type="radio" id="star4" name="overAllReview" value="4" />
                                        <label for="star4" title="text">4 stars</label>
                                        <input type="radio" id="star3" name="overAllReview" value="3" />
                                        <label for="star3" title="text">3 stars</label>
                                        <input type="radio" id="star2" name="overAllReview" value="2" />
                                        <label for="star2" title="text">2 stars</label>
                                        <input type="radio" id="star1" name="overAllReview" value="1" />
                                        <label for="star1" title="text">1 star</label>
                                    </div>   
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="inputName">Ease of Use</label>
                                <div class="form-group col-md-12">
                                    
                                    <div class="rate">
                                        <input type="radio" id="estar5" name="easeOfUse" value="5" />
                                        <label for="estar5" title="text">5 stars</label>
                                        <input type="radio" id="estar4" name="easeOfUse" value="4" />
                                        <label for="estar4" title="text">4 stars</label>
                                        <input type="radio" id="estar3" name="easeOfUse" value="3" />
                                        <label for="estar3" title="text">3 stars</label>
                                        <input type="radio" id="estar2" name="easeOfUse" value="2" />
                                        <label for="estar2" title="text">2 stars</label>
                                        <input type="radio" id="estar1" name="easeOfUse" value="1" />
                                        <label for="estar1" title="text">1 star</label>
                                    </div>   
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="inputName">Functionalities</label>
                                <div class="form-group col-md-12">
                                    
                                    <div class="rate">
                                        <input type="radio" id="fstar5" name="functionalities" value="5" />
                                        <label for="fstar5" title="text">5 stars</label>
                                        <input type="radio" id="fstar4" name="functionalities" value="4" />
                                        <label for="fstar4" title="text">4 stars</label>
                                        <input type="radio" id="fstar3" name="functionalities" value="3" />
                                        <label for="fstar3" title="text">3 stars</label>
                                        <input type="radio" id="fstar2" name="functionalities" value="2" />
                                        <label for="fstar2" title="text">2 stars</label>
                                        <input type="radio" id="fstar1" name="functionalities" value="1" />
                                        <label for="fstar1" title="text">1 star</label>
                                    </div>   
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="comment">Comments</label>
                                <textarea id="comment" name="comment" class="form-control" rows="3"></textarea>
                            </div>
                        </div>
                      
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
        
    </div>
    <div class="row">
        <div class="col-12">
            <a href="/admin/users" class="btn btn-secondary">Cancel</a>
            <input type="submit" value="Submit Feedback" class="btn btn-success float-right">
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/user/create.js" . "?v=" . config("app.version") }}"></script>
@endsection