@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Dropbox Accounts</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item active">Dropbox Accounts</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Dropbox Account Management</h3>
            @if(\App\Models\Permission::canCreate(session('allUserAccesses')['dropbox'])))
            <div style="float:right">
              <a class="btn btn-primary btn-sm" href="/dropbox/create">  
              <li class= "fa fa-cog"></li> Add New Dropbox Account
              </a>
            </div>
            @endif
        </div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <table id="dropboxAccountsTable" class="table table-striped projects">
                    <thead>
                        <tr>
                            <th style="width: 20%">
                                Name
                            </th>
                            <th style="width: 30%">
                                Description
                            </th>
                            <th>
                                App Key
                            </th>
                            <th>
                                App Secret
                            </th>
                            <th>
                                Access Token
                            </th>
                            <th style="width: 20%">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/dropbox/index.js" . "?v=" . config("app.version") }}"></script>
<script>
    getDropboxAccounts();

</script>
@endsection
