@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Manage Users</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/admin/users">Users</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit User</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    <form id="frmUpdateUser" name="frmUpdateUser" role="form" action="{{ url("/admin/users/$user->id/update") }}"
        enctype="multipart/form-data" method="POST">
        {{ csrf_field() }}
        <input type="hidden" id="_method" name="_method" value="PUT" />
        <input type = "hidden" id="access" name="access"/>
        <div class="row">
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">USER INFORMATION</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">First Name</label>
                                <input type="text" id="first_name" name="first_name" class="form-control"
                                    value="{{$user->first_name}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Last Name</label>
                                <input type="text" id="last_name" name="last_name" class="form-control"
                                    value="{{$user->last_name}}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Email Address</label>
                                <input type="email" id="email" name="email" class="form-control"
                                    value="{{$user->email}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Mobile Number</label>
                                <input type="text" id="mobile_number" name="mobile_number" class="form-control"
                                    value="{{$user->mobile_number}}"  onchange="phonenumber(this);">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="status">Status</label>
                                <select id="status" name="status" class="form-control">
                                    <option selected disabled>Select one</option>
                                    <option value="A" {{$user->status == "A" ? "selected" : "" }}>Active</option>
                                    <option value="I" {{$user->status == "I" ? "selected" : "" }}>Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                </div>
                <!-- /.card -->
            </div>
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">MEMBER OF</div>
                    <div class="card-body">
                        <div class="col-sm-12">
                            <div class="row">
                                @foreach($roles as $role)
                                <div class="col-sm-3">
                                    <div class="icheck-material-success">
                                        <input type="checkbox" name="{{$role->name}}"
                                            id="{{$role->id}}" value="{{$role->id}}"
                                            class="sys-role-cb"
                                            {{(in_array($role->id,$roleUserAccess)) ? "checked" : "" }} />
                                        <label for="{{$role->id}}" class="control-label">{{$role->name}}</label>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                </div>
                <!-- /.card -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <a href="/admin/users" class="btn btn-secondary">Cancel</a>
                <input type="submit" value="Update User" class="btn btn-success float-right">
            </div>
        </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/user/edit.js" . "?v=" . config("app.version") }}"></script>
@endsection
