
@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Manage Role</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/admin/roles">Roles</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Role</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    <form id="frmUpdateRole" name="frmUpdateRole" role="form" action="{{ url("/admin/roles/$role->id") }}"
        enctype="multipart/form-data" method="POST">
        {{ csrf_field() }}
        <input type = "hidden" id="_method" name="_method" value="PUT" />
        <input type = "hidden" id="access" name="access"/>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Role Details</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Role</label>
                                <input type="text" id="role" name="role" class="form-control" value="{{$role->name}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Description</label>
                                <input type="text" id="description" name="description" class="form-control"
                                    value="{{$role->remark}}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <table id="tblACL" name="tblACL" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="30%">Modules</th>
                                            <th width="70%">Permissions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($permissionGroups as $permissionGroup)
                                        <tr id="main-{{$permissionGroup['id']}}" class="main-tr">
                                            <td data-toggle="tooltip" data-html="true"
                                                title="{!! html_entity_decode($permissionGroup['description'])!!}">
                                                <b>{{$permissionGroup['name']}}</b>
                                            </td>
                                            <td>
                                                <div class="row">
                                                    @foreach($permissionGroup['accesses'] as $access => $value)
                                                    <div class="col-sm-4">
                                                        <div class="icheck-material-success">
                                                        <input data-toggle="tooltip" data-html="true"
                                                            title="{!! html_entity_decode($value['description'])!!}"
                                                            type="checkbox" name="{{$value['id']}}"
                                                            id="acl-{{$value['id']}}" value="{{$value['id']}}"
                                                            class="acl-cb" 
                                                            {{(in_array($value['id'], $role_access))? "checked" : "" }}
                                                            />
                                                            <label  for="acl-{{$value['id']}}" >{{$value['supported_right']}}</label>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                    <!-- /.card-body -->

                </div>
                <!-- /.card -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <a href="/admin/roles" class="btn btn-secondary">Cancel</a>
                <input type="submit" value="Update role" class="btn btn-success float-right">
            </div>
        </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/role/create.js" . "?v=" . config("app.version") }}"></script>
@endsection
