@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Manage Users</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Permissions</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            @if(\App\Models\Permission::canCreate(session('allUserAccesses')['permissions']))
            <div style="float:right">
              <a class="btn btn-primary btn-sm" href="/admin/permissions/create">  
              <li class= "fa fa-cog"></li> Add New Permission
              </a>
            </div>
            @endif
        </div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <table id="usersTable" class="table table-striped projects">
                    <thead>
                        <tr>
                            <th style="width: 20%">
                                Category
                            </th>
                            <th style="width: 30%">
                                Permission
                            </th>
                            <th>
                                URL
                            </th>
                            <th>
                                Access
                            </th>
                            <th style="width: 20%">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->
@endsection
@include('incs.datatable')
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/permission/index.js" . "?v=" . config("app.version") }}"></script>
<script>
    getPermissions();

</script>
@endsection
