@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Manage Permission</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/admin/permissions">Permissions</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Permission</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>


<!-- Main content -->
<section class="content">
<form id="frmUpdatePermission" name="frmUpdatePermission" role="form" action="{{ url("/admin/permissions/$permission->id/update") }}"
    enctype="multipart/form-data" method="POST">
    <input type="hidden" id="_method" name="_method" value="PUT" />
    <input type="hidden" id="supportedRight" name="supportedRight" value="{{$permission->supported_right}}" />
    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Permission Details</h3>
                </div>
                <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Name</label>
                                <input type="text" id="permission" name="permission" class="form-control"
                                       value="{{$permission->permission}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Description</label>
                                <input type="text" id="description" name="description" class="form-control"
                                  value="{{$permission->description}}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">URL Value</label>
                                <input type="text" id="url" name="url" class="form-control"
                                  value="{{$permission->url}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Category</label>
                                <select id="category"  name="category" class="form-control ">
                                    @if(count($categories)>0)
                                		@foreach($categories as $category)
                                    		<option value="{{$category->id}}"  {{$permission->resource_group_id == $category->id ? "selected" : "" }}>{{$category->value}}</option>
                                    	@endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputStatus">Access</label>
                                <select id="access"  name="access" class="form-control ">
                                </select>
                            </div>
                        </div>
                      
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <a href="/admin/permissions" class="btn btn-secondary">Cancel</a>
            <input type="submit" value="Update" class="btn btn-success float-right">
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/permission/edit.js" . "?v=" . config("app.version") }}"></script>
@endsection