
import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

function getDropboxAccounts() {

    showLoading('Loading Dropbox Accounts...', 'Please wait while we load the data')
    let url  = '/dropbox/getData'
    
    require('axios-debug-log')
    axios.get(url, {
        params: {
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        closeLoading()
        $('#dropboxAccountsTable').dataTable().fnDestroy();
        var oTable = $('#dropboxAccountsTable').dataTable({
            "bRetrieve": true
        });
        oTable.fnClearTable();
        if (Object.keys(response.data).length > 0)
        {
            oTable.fnAddData(response.data);
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

window.getDropboxAccounts = getDropboxAccounts;