import swal from "sweetalert2";
import axios from "axios";


$(document).ready(function () {

    
    $(".roles-cb").change(function() {
        callGetUsersByRoleId();    
    });

    /* initialize the external events
     -----------------------------------------------------------------*/
     //Date range picker with time picker


    /* initialize the calendar
     -----------------------------------------------------------------*/
    //Date for the calendar events (dummy data)
    var date = new Date()
    var d = date.getDate(),
        m = date.getMonth(),
        y = date.getFullYear()

    var Calendar = FullCalendar.Calendar;

    var containerEl = document.getElementById('external-events');
    var checkbox = document.getElementById('drop-remove');
    var calendarEl = document.getElementById('calendar');

    // initialize the external events
    // -----------------------------------------------------------------


    var calendar = new Calendar(calendarEl, {
        plugins: ['bootstrap', 'interaction', 'dayGrid', 'timeGrid'],
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        //Random default events
        events: '/calendar/getData',
        editable: true,
        selectable: true,
        selectHelper: true,
        droppable: true, // this allows things to be dropped onto the calendar !!!
        select: function (start, end, allDay) {
            var start = moment(start.startStr).format("MM/DD/YYYY hh:mm A");
            $('#calendarActivityDateTime').val(start + " - " + start);
            $('#calendarTitle').val('');
            $('#calendarDescription').val('');
            $('#calendarColor').val('');
            $('#modal-title').text('Create Calendar Activity');
            $('#divUpdate').hide();
            $('#divDelete').hide();
            $('#divCreate').show();
            $("#calendarTitle").prop("readonly", false);    
            $("#calendarDescription").prop("readonly", false);    
            $("#calendarActivityDateTime").prop("readonly", false);
            $("#isPrivate").prop("readonly", false);
            $("#isPublic").prop("readonly", false);
            $("#isPrivate").prop("checked", false);
            $("#isPublic").prop("checked", true);
            $("#isPrivate").removeAttr("disabled");
            $("#isPublic").removeAttr("disabled"); 
            setTimeout(function() { 
                $("#divIsPrivate :input").attr("disabled", false); 
            }, 2000);     
            $('#calendarColor').prop("readonly", false);
            $(".classRadio").trigger('change');  
            $(".roles-cb").prop("checked", false);
            //$('#calendarActivityDateTime').val("08/21/2020 12:00 AM - 08/21/2020 11:59 PM");
            $('#modal-calendar-activity').modal('show'); 
            
        },
        eventResize: function (event) {
            console.log(event.event.end)
            let url = '/calendar/update'
            var start = moment(event.event.start).format("YYYY-MM-DD HH:mm:ss");
            var end = moment(event.event.end).format("YYYY-MM-DD HH:mm:ss");
            let formData = new FormData();
            var id = event.event.id;
            formData.append('id', id);
            formData.append('start', start);
            formData.append('end', end);
            showLoading('Updating Calendar Activity', 'Please wait...')
            axios.post(url, formData)
                .then(function (response) {
                    console.log('Response:', response);
                    if (response.data.message == "Success") {
                        showPrompt('Calendar',
                            'Successfully updated activity on calendar')
                    } else {
                        showPrompt('Something went wrong',
                            'There was an error processing you request, Please try again.')
                    }
                    closeLoading()
                })
                .catch(function (error) {
                    showPrompt('Something went wrong',
                        'There was an error processing you request, if you believe\
                  this is a bug, please contact our team')
                    closeLoading()
                })
        },
        eventClick: function (event) {
            loadCalendarActivity(event.event.id);    
        },
        eventDrop: function (event) {
            //console.log(event.event.id)
            let url = '/calendar/update'
            var start = moment(event.event.start).format("YYYY-MM-DD HH:mm:ss");
            var end = moment(event.event.end).format("YYYY-MM-DD HH:mm:ss");
            var title = event.event.title;
            var description = event.event.description;
            var id = event.event.id;
            let formData = new FormData();
            formData.append('id', id);
            //formData.append('title', title);
            formData.append('start', start);
            formData.append('end', start);
            axios.post(url, formData)
                .then(function (response) {
                    console.log('Response:', response);
                    if (response.data.message == "Success") {
                        calendar.refetchEvents();
                        showPrompt('Calendar',
                            'Successfully updated activity on calendar')
                    } else {
                        showPrompt('Something went wrong',
                            'There was an error processing you request, Please try again.')
                    }
                    closeLoading()
                })
                .catch(function (error) {
                    showPrompt('Something went wrong',
                        'There was an error processing you request, if you believe\
                    this is a bug, please contact our team')
                    closeLoading()
                })
        },
    });

    calendar.render();
    // $('#calendar').fullCalendar()

    /* ADDING EVENTS */
    var currColor = '#3c8dbc' //Red by default
    //Color chooser button
    var colorChooser = $('#color-chooser-btn')
    $('#color-chooser > li > a').click(function (e) {
        e.preventDefault()
        //Save color
        currColor = $(this).css('color')
        //Add color effect to button
        $('#add-new-event').css({
            'background-color': currColor,
            'border-color': currColor
        })
    }) 
    $('#add-new-event').click(function (e) {
        e.preventDefault()
        //Get value and make sure it is not null
        var val = $('#new-event').val()
        if (val.length == 0) {
            return
        }

        //Create events
        var event = $('<div />')
        event.css({
            'background-color': currColor,
            'border-color': currColor,
            'color': '#fff'
        }).addClass('external-event')
        event.html(val)
        $('#external-events').prepend(event)

        //Add draggable funtionality
        //ini_events(event)

        //Remove event from text input
        $('#new-event').val('')
    })

    
    $("#btnDeleteCalendar").click(function() {
            showLoading('Removing Calendar Activity', 'Please wait...')
            if (confirm("Are you sure you want to remove it?")) {
                var id = $('#calendarId').val();
                let url = '/calendar/delete'
                let formData = new FormData();
                formData.append('id', id);
                console.log('Event:', event);
                axios.post(url, formData)
                    .then(function (response) {
                        console.log('Response:', response);
                        if (response.data.message == "Success") {
                            calendar.refetchEvents();
                            showPrompt('Calendar',
                                'Successfully deleted activity on calendar')
                        } else {
                            showPrompt('Something went wrong',
                                'There was an error processing you request, Please try again.')
                        }
                        closeLoading()
                    })
                    .catch(function (error) {
                        showPrompt('Something went wrong',
                            'There was an error processing you request, if you believe\
                  this is a bug, please contact our team')
                        closeLoading()
                    })
            }
            closeLoading()
            $('#modal-calendar-activity').modal('hide'); 
    });

    $("#btnSubmitCalendar").click(function() {
      generateSharedAccess();
      if (confirm('Submit calendar activity?')) {
          let url = '/calendar/store'
          //console.log(start.endStr);
          var daterange = $('#calendarActivityDateTime').val();
          var dates = daterange.split('-');
          var start = dates[0]; //moment(start.startStr).format("YYYY-MM-DD hh:mm:ss");
          var end = dates[1]; //moment(start.endStr).format("YYYY-MM-DD hh:mm:ss");
          let formData = new FormData();
          var isPrivate = 0;
          if($('#isPrivate').is(':checked'))
          {  
             var isPrivate = 1;
          } 
          //console.log(end);
          showLoading('Adding Calendar Activity', 'Please wait...')
          formData.append('title', $('#calendarTitle').val());
          formData.append('description', $('#calendarDescription').val());
          formData.append('start', start);
          formData.append('end', end);
          formData.append('color', $('#calendarColor').val());
          formData.append('sharedAccess', $('#sharedAccessId').val());
          formData.append('isPrivate', isPrivate);
          const config = {
              headers: {
                  'content-type': 'multipart/form-data',
                  'X-Requested-With': 'XMLHttpRequest'
              }
          }
          axios.post(url, formData)
              .then(function (response) {
                  console.log('Response:', response);
                  if (response.data.message == "Success") {
                      showPrompt('Calendar',
                          'Successfully added activity on calendar')
                      calendar.refetchEvents();
                      // setTimeout(function() {
                      //     window.location.href = APP_URL+'/calendar';
                      // }, 1000); 

                  } else {
                      showPrompt('Something went wrong',
                          'There was an error processing you request, Please try again.')
                  }
                  closeLoading()

              })
              .catch(function (error) {
                  showPrompt('Something went wrong',
                      'There was an error processing you request, if you believe\
              this is a bug, please contact our team')
                  closeLoading()
              })
            }
            $('#modal-calendar-activity').modal('hide'); 
    });

    $("#btnUpdateCalendar").click(function() {
        generateSharedAccess();
        if (confirm('Update calendar activity')) {
            let url = '/calendar/update'
            //console.log(start.endStr);
            var daterange = $('#calendarActivityDateTime').val();
            var dates = daterange.split('-');
            var start = moment(dates[0]).format("YYYY-MM-DD HH:mm:ss");
            var end = moment(dates[1]).format("YYYY-MM-DD HH:mm:ss");
            let formData = new FormData();
            var isPrivate = 0;
            if($('#isPrivate').is(':checked'))
            {  
               var isPrivate = 1;
            } 
            //console.log(end);
            showLoading('Adding Calendar Activity', 'Please wait...')
            formData.append('id', $('#calendarId').val());
            formData.append('title', $('#calendarTitle').val());
            formData.append('description', $('#calendarDescription').val());
            formData.append('start', start);
            formData.append('end', end);
            formData.append('color', $('#calendarColor').val());
            formData.append('sharedAccess', $('#sharedAccessId').val());
            formData.append('isPrivate', isPrivate);
            const config = {
                headers: {
                    'content-type': 'multipart/form-data',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            }
            axios.post(url, formData)
                .then(function (response) {
                    console.log('Response:', response);
                    if (response.data.message == "Success") {
                        showPrompt('Calendar',
                            'Successfully added activity on calendar')
                        calendar.refetchEvents();
                        // setTimeout(function() {
                        //     window.location.href = APP_URL+'/calendar';
                        // }, 1000); 
  
                    } else {
                        showPrompt('Something went wrong',
                            'There was an error processing you request, Please try again.')
                    }
                    closeLoading()
  
                })
                .catch(function (error) {
                    showPrompt('Something went wrong',
                        'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
                    closeLoading()
                })
              }
              $('#modal-calendar-activity').modal('hide'); 
      });

    $('#calendarActivityDateTime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })

    $(".classRadio").change(function() {
        if($('#isPrivate').is(':checked'))
        {  
            $('#divIsPrivate').show();
        } else {
            $('#divIsPrivate').hide();
        }
        $(".roles-cb").prop("checked", false);
    });
})

function generateSharedAccess()
{
    var access='';
    $('.users-cb:checkbox:checked').each(function () {
            access = access +  $(this).val() + ",";
    });
    if (access !="")
    {
        $("#sharedAccessId").val(access);
    }
}

function callGetUsersByRoleId(isCheck=true)
{
    var access='';
    $('.roles-cb:checkbox:checked').each(function () {
            access = access +  $(this).val() + ",";
    });
    $("#divUsers").empty();
    if (access != '')
    {
        getUsersByRoleId(access,isCheck);
    }
}

function getUsersByRoleId(roleId,isCheck=true) {

    showLoading('Loading Users...', 'Please wait while we load the data')
    let url  = '/dropbox/getUsersByRole'
    require('axios-debug-log')
    axios.get(url, {
        params: {
            'id' : roleId
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        for (var i = 0; i < response.data.length; i++) {

            var checkbox =  $(document.createElement("input")).attr({
                id:  'user-'+response.data[i].id,
                name:  response.data[i].last_name + ', ' + response.data[i].first_name,
                value: response.data[i].id,
                type:  'checkbox',
                class: 'users-cb',
                checked: isCheck
       })

        var label =  '<label>'+response.data[i].last_name + ', ' + response.data[i].first_name+'</label><br>';
        $("#divUsers").append(checkbox);
        $("#divUsers").append(label);

  
        }
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function getRoleUsers(calendarId) {

    showLoading('Loading Role Users...', 'Please wait while we load the data')
    let url  = '/calendar/getCalendarSharedAccess'
    require('axios-debug-log')
    axios.get(url, {
        params: {
            'id' : calendarId,
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        var ids="";
        for (var i = 0; i < response.data.length; i++) {
            $("#" + response.data[i].role_id).prop('checked', true);
        }
        callGetUsersByRoleId(false);
        setTimeout(function() { 
            for (var i = 0; i < response.data.length; i++) {
                $("#user-" + response.data[i].user_id).prop('checked', true);
            }
        }, 1000);
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function loadCalendarActivity(id)
{
    let url  = '/calendar/getCalendarActivity'
    $('#calendarId').val(id);
    require('axios-debug-log')
    axios.get(url, {
        params: {
            'id' : id
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        var start = moment(response.data.start).format("MM/DD/YYYY hh:mm A");
        var end = moment(response.data.end).format("MM/DD/YYYY hh:mm A");
        $('#calendarTitle').val(response.data.title);
        $('#calendarDescription').val(response.data.description);
        $('#calendarActivityDateTime').val(start + ' - ' + end);
        $('#calendarColor').val(response.data.color);
        $('.my-colorpicker .fa-square').css('color', response.data.color);
        getRoleUsers(response.data.id);
        if (response.data.is_private ==1)
        {
            $("#isPrivate").prop("checked", true);
            $("#isPublic").prop("checked", false);
        } else {
            $("#isPrivate").prop("checked", false);
            $("#isPublic").prop("checked", true);
        }
        $(".classRadio").trigger('change'); 
        if ($('#userId').val()==response.data.user.id)
        {
            $('#divDelete').show();
            $('#divUpdate').show();
            $('#divCreate').hide();
            $("#calendarTitle").prop("readonly", false);    
            $("#calendarDescription").prop("readonly", false);    
            $("#calendarActivityDateTime").prop("readonly", false);  
            $("#calendarColor").prop("readonly", false);
            $("#isPrivate").removeAttr("disabled");
            $("#isPublic").removeAttr("disabled"); 
            setTimeout(function() { 
                $("#divIsPrivate :input").attr("disabled", false); 
            }, 2000); 
            $('#calendarColor').prop("readonly", false);
            $('#modal-title').text(response.data.user.first_name + ' - Update Calendar Activity');  
        } else { 
            $('#divDelete').hide();
            $('#divUpdate').hide();
            $('#divCreate').hide();
            $("#calendarTitle").prop("readonly", true);    
            $("#calendarDescription").prop("readonly", true);    
            $("#calendarActivityDateTime").prop("readonly", true);
            $("#calendarColor").prop("readonly", true);
            $("#isPrivate").prop("disabled", true);
            $("#isPublic").prop("disabled", true);  
            setTimeout(function() { 
                $("#divIsPrivate :input").attr("disabled", true); 
            }, 2000);
            $('#modal-title').text(response.data.user.first_name + ' - View Calendar Activity');     
        }
        $('#modal-calendar-activity').modal('show');
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })
}

window.getUsersByRoleId = getUsersByRoleId;
window.getRoleUsers = getRoleUsers;
window.callGetUsersByRoleId = callGetUsersByRoleId;