<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVideoRoomsAddEmail extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('video_rooms', 'email_address')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->string('email_address',100)->default('');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('video_rooms', 'email_address')) {
            Schema::table('video_rooms', function (Blueprint $table) {
                $table->dropColumn('email_address');
            });
        }
    }
}
