<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectOrders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('sales_representative_id')->nullable();
            $table->integer('project_number')->nullable();
            $table->string('project_name')->nullable();
            $table->dateTime('start_date',0);
            $table->dateTime('end_date',0);
            $table->dateTime('training_date',0);
            $table->string('call_days',10)->nullable();
            $table->string('gross_list_size',10)->nullable();
            $table->string('state',10)->nullable();
            $table->string('local_did',30)->nullable();
            $table->string('caller_did',30)->nullable();
            $table->boolean('is_cell_scrub')->nullable();
            $table->string('client_goal',50)->nullable();
            $table->integer('program_type_id')->nullable();
            $table->integer('goal_type_id')->nullable();
            $table->string('project_minimum_expectations',100)->nullable();
            $table->string('project_notes')->nullable();
            $table->string('transfer_number',50)->nullable();
            $table->boolean('need_recording')->nullable();
            $table->string('blended_hours',50)->nullable();
            $table->string('website_link')->nullable();
            $table->string('facebook_link')->nullable();
            $table->string('dial_type_id')->nullable();
            $table->string('status')->default('A');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_orders');
    }
}
