<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterUsersAddCreateByUpdateBy extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'create_by')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('create_by')->nullable();
            });
        }

        if (!Schema::hasColumn('users', 'update_by')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('update_by')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'create_by')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('create_by');
            });
        }

        if (Schema::hasColumn('users', 'update_by')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('update_by');
            });
        }
    }
}
