<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupportedRights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supported_rights', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('code',20)->nullable();
            $table->string('name')->nullable();
            $table->char('status',10)->nullable();
            $table->integer('sequence')->nullable();
            $table->string('create_by',20)->nullable();
            $table->string('update_by',20)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supported_rights');
    }
}
