<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTablePermissionGroupsAddSupportedRights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('permission_groups', 'supported_rights')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->string('supported_rights',255)->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('permission_groups', 'supported_rights')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->dropColumn('supported_rights');
            });
        }
    }
}
