<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTablePermissionsAddSupportedRights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('permissions', 'supported_rights')) {
            Schema::table('permissions', function (Blueprint $table) {
                $table->string('supported_right',255)->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('permissions', 'supported_rights')) {
            Schema::table('permissions', function (Blueprint $table) {
                $table->dropColumn('supported_right');
            });
        }
    }
}
