<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTablePermissionGroupAddCode extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('permission_groups', 'code')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->string('code', 50)->nullable();
            });
        }

        if (!Schema::hasColumn('permission_groups', 'type')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->string('type', 10)->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('permission_groups', 'code')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->dropColumn('code');
            });
        }

        if (Schema::hasColumn('permission_groups', 'type')) {
            Schema::table('permission_groups', function (Blueprint $table) {
                $table->dropColumn('type');
            });
        }
    }
}
