<?php

namespace App\Services\Report;

use App\Contracts\Report\ReportActionService;
use App\Models\EmailOnQueue;
use App\Models\Permission;
use App\Models\VideoRoom;
use App\Services\BaseServiceImpl;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class ReportActionServiceImpl extends BaseServiceImpl implements ReportActionService
{
    public function listSessionData(Request $request)
    {
        // $access = session('allUserAccesses')['report'];
        $datefrom = Carbon::parse($request->datefrom)->format('Y-m-d');
        $dateto = Carbon::parse($request->dateto)->addDays(1)->format('Y-m-d');

        $videos = VideoRoom::where('status', VideoRoom::VIDEO_COMPLETED)
            ->whereBetween('created_at', [$datefrom, $dateto])
            ->orderBy('id', 'desc')
            ->get();

        $cnt = 1;
        $result = array();
        foreach ($videos as $video)
        {
            $contact = $video->mobile_number;
            $result[] = array(
                $cnt++,
                $video->room_id,
                $contact,
                Carbon::parse($video->created_at)->format('M d, Y h:i a'),
                Carbon::parse($video->updated_at)->format('M d, Y h:i a')
            );
        }

        $resultObject = (object) [
            'video' => $result
        ];

        return $resultObject;
    }

    public function createEmailOnQueue($params)
    {
        $emailOnQueue = new EmailOnQueue;
        $emailOnQueue->subject = $params['subject'];
        $emailOnQueue->template =   $params['template'];
        $emailOnQueue->parameters =   $params['parameters'];
        $emailOnQueue->email_address =  $params['email_address'];
        $emailOnQueue->create_by = auth()->user()->username;
        $emailOnQueue->is_sent = 0;
        $emailOnQueue->sent_date = null;
        $emailOnQueue->save();
    }
}
