<?php

namespace App\Services\Admin;

use App\Contracts\Admin\RoleActionService;
use App\Models\EmailOnQueue;
use App\Models\Permission;
use App\Models\PermissionGroup;
use App\Models\Role;
use App\Models\SupportedRight;
use App\Services\BaseServiceImpl;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class RoleActionServiceImpl extends BaseServiceImpl implements RoleActionService
{
    public function listRoles()
    {
        $access = session('allUserAccesses')['roles'];
        $roles = Role::where('status','<>','D')->get();
        $message="'Delete this role?'";
        $result = array();
        foreach ($roles as $role)
        {
            $view = ' <a class="btn btn-primary btn-sm" href="/admin/roles/'.$role->id.'">
                            <i class="fa fa-folder">
                            </i>
                            View
                        </a>';
            $edit = ' <a class="btn btn-success btn-sm" href="/admin/roles/'.$role->id.'/edit">
                        <i class="fa fa-pencil">
                        </i>
                        Edit
                    </a>';
            $delete = ' <a class="btn btn-danger btn-sm" href="/admin/roles/'.$role->id.'/delete"  onclick="return confirm('.$message.')">
                    <i class="fa fa-trash">
                    </i>
                    Delete
                </a>';
            
            //check access
            if (!Permission::canView($access)) $view="";
            if (!Permission::canEdit($access)) $edit="";
            if (!Permission::canDelete($access)) $delete="";

            $result[] = array(
                $role->name,
                $role->remark,
                $view.' '. $edit.' '.$delete
            );
        }

        $resultObject = (object) [
            'roles' => $result
        ];

        return $resultObject;
    }

    public function getPermissions()
    {
        $permissionGroups = PermissionGroup::where('status','A')->get();
        $result = array();
        foreach ($permissionGroups as $permissionGroup)
        {
            $access = Permission::where('permission_group_id',$permissionGroup->id)->where('status','A')->get()->toArray();
            
            $result[] = array(
                    'id' => $permissionGroup->id,
                    'name' => $permissionGroup->value,
                    'description' => $permissionGroup->description,
                    'accesses' =>  $access,
                );
   
        }
        return $result;
    }

}
