<?php

namespace App\Services\Admin;

use App\Contracts\Admin\PermissionActionService;
use App\Models\EmailOnQueue;
use App\Models\Permission;
use App\Models\PermissionGroup;
use App\Models\SupportedRight;
use App\Services\BaseServiceImpl;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class PermissionActionServiceImpl extends BaseServiceImpl implements PermissionActionService
{
    public function listPermissions()
    {
        $access = session('allUserAccesses')['permissions'];
        $permissions = Permission::where('status','<>','D')->get();
        $message="'Delete this permission?'";
        $result = array();
        foreach ($permissions as $permission)
        {
            $view = ' <a class="btn btn-primary btn-sm" href="/admin/permissions/'.$permission->id.'">
                            <i class="fa fa-folder">
                            </i>
                            View
                        </a>';
            $edit = ' <a class="btn btn-success btn-sm" href="/admin/permissions/'.$permission->id.'/edit">
                        <i class="fa fa-pencil">
                        </i>
                        Edit
                    </a>';
            $delete = ' <a class="btn btn-danger btn-sm" href="/admin/permissions/'.$permission->id.'/delete"  onclick="return confirm('.$message.')">
                    <i class="fa fa-trash">
                    </i>
                    Delete
                </a>';

            //check access
            if (!Permission::canView($access)) $view="";
            if (!Permission::canEdit($access)) $edit="";
            if (!Permission::canDelete($access)) $delete="";

            $result[] = array(
                $permission->permissionGroup->value,
                $permission->permission,
                $permission->url,
                $permission->supported_right,
                $view.' '. $edit.' '.$delete
            );
        }

        $resultObject = (object) [
            'permissions' => $result
        ];

        return $resultObject;
    }

    public function getSupportedRights($resourceGroupId)
    {
        $result = array();
        $resourceGroup = PermissionGroup::find($resourceGroupId);
        
        if(isset($resourceGroup->supported_rights))
        {
            $supportedRights = SupportedRight::whereIn('code',explode(",",$resourceGroup->supported_rights))->get();
            $result = $supportedRights;
        }

        $resultObject = (object) [
            'supportedRights' => $result
        ];
        //dd($resultObject);
        return $resultObject;
    }

}
