<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use DB;
class User extends Authenticable
{
    /**
     * Status
     */
    const USER_ACTIVE = "A";
    const USER_INACTIVE = "I";
    
    protected $table = "users";

    use HasApiTokens, Notifiable;

    /**
     * Role User
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany('App\Models\Role', 'role_user', 'user_id', 'role_id');
    }

    /**
     * Role User
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function calendar()
    {
        return $this->hasMany('App\Models\Calendar', 'calendar_activities', 'user_id', 'id');
    }

    /**
     * Role User
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function feedback()
    {
        return $this->hasMany('App\Models\Feedback', 'feedbacks', 'user_id', 'id');
    }

    /**
     * Get Distinct Users By Role IDs using RAW SQL
     */
    public static function getDistinctUsersByRoleId($id)
    {
        $rs = DB::select(DB::raw("SELECT DISTINCT U.*
            FROM users U 
            INNER JOIN role_user RU ON RU.`user_id` = U.`id`
            INNER JOIN roles R ON R.id = RU.`role_id` AND R.id IN ($id)
            ORDER BY U.last_name, U.first_name
        "));

        return $rs;
    }


    
    /** 
     * SCOPES
    */
    public function scopeOfSecCode($query, $secCode)
	{
        if (isset($secCode) || $secCode!="") {
            return $query->where('sec_code', '=', $secCode);
        }
        return $query;
    }
    
}
