<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $table = "roles";

     /**
     * Users
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function users()
    {
        return $this->belongsToMany('App\Models\User');
    }

    /** 
     * SCOPES
    */
    public function scopeOfGroupCode($query, $groupCode)
	{
        if (isset($groupCode) || $groupCode!="") {
            return $query->where('group_code', '=', $groupCode);
        }
        return $query;
	}
}
