<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PermissionGroup extends Model
{
    protected $table = "permission_groups";
    

    /** 
     * SCOPES
    */
    public function scopeOfCode($query, $code)
	{
        if (isset($code) || $code!="") {
            return $query->where('code', '=', $code);
        }
        return $query;
    }
    
    public function scopeIsActive($query)
	{    
        return $query->where('status', '=', 'A');
	}
}
