<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use DB;
class Permission extends Model
{

    /**
     * Status
     */
    const PERMISSION_ACTIVE = "A";
    const PERMISSION_INACTIVE = "I";
    const PERMISSION_DELETED = "D";

    protected $table = "permissions";
    protected $fillable = ['created_at','create_by','update_by'];


    /**
     *  Generate Access Rights
     */

    public static function generateAllUserAccess($user_id){
        $accesses = Permission::_getAllUserAccesses($user_id);
        $all_user_access = array();
        $mod_name = "";
        $access = "";
        foreach($accesses as $a){
            if ($mod_name==""){$mod_name = $a->module_name;}
            if ($mod_name == $a->module_name)
            {
                $access = $access . $a->module_access . ",";  
            } else {
                $access = substr($access, 0, strlen($access) - 1); 
                $all_user_access = $all_user_access +  array(
                    strtolower($mod_name) => strtolower($access),    
                );
               $access="";
               $mod_name = $a->module_name; 
               $access = $access . $a->module_access . ",";                                                                            
            }
        }

        if (strlen($access)>0){
            $access = substr($access, 0, strlen($access) - 1); 
            $all_user_access = $all_user_access +  
                array(
                    strtolower($mod_name) => strtolower($access),    
                );
        }

        return $all_user_access;
    }
    public static function canCreate($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("create", $arruserAccesses)) { 
            $canCreate = true;
        }else{ 
            $canCreate = false;
        } 
        return $canCreate;
    }
    public static function canEdit($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("edit", $arruserAccesses)) { 
            $canEdit = true;
        }else{ 
            $canEdit = false;
        } 
        return $canEdit;
    }
    public static function canDelete($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("delete", $arruserAccesses)) { 
            $canDelete = true;
        }else{ 
            $canDelete = false;
        } 
        return $canDelete;
    }

    public static function canView($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("view", $arruserAccesses)) { 
            $canView = true;
        }else{ 
            $canView = false;
        } 
        return $canView;
    }

    public static function canDownload($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("download", $arruserAccesses)) { 
            $canDownload = true;
        }else{ 
            $canDownload = false;
        } 
        return $canDownload;
    }

    public static function canReset($userAccesses){
        $arruserAccesses = explode(",", $userAccesses);
        if (in_array("reset", $arruserAccesses)) { 
            $canReset = true;
        }else{ 
            $canReset = false;
        } 
        return $canReset;
    }
   
    private static function _getAllUserAccesses($user_id){
        //DB::enableQueryLog(); 
        $result = DB::table('permission_role')->distinct()
                ->join('permissions','permissions.id','=','permission_role.permission_id')
                ->join('permission_groups','permission_groups.id','=','permissions.permission_group_id')
                ->join('roles','roles.id','=','permission_role.role_id')
                ->join('role_user','roles.id','=','role_user.role_id')
                ->join('users','users.id','=','role_user.user_id')
                ->select('permission_groups.value as module_name','permissions.supported_right as module_access')
                ->where('users.id', $user_id)
                ->orderBy('permission_groups.value','asc')
                ->orderBy('permissions.supported_right','asc')->get();
        //dd(DB::getQueryLog());
        return $result;
    }

    public static function generateReportMenu($userId)
    {
        $cmd = "SELECT 
                *
                FROM permissions P
                INNER JOIN permission_role PR ON PR.permission_id = P.id
                INNER JOIN roles R ON R.id = PR.role_id
                INNER JOIN role_user RU ON RU.role_id = R.id
                WHERE RU.user_id = {$userId} AND P.url LIKE 'report/%'";
        $result = DB::select(DB::raw($cmd));
        return  (object)$result;
    }

    /**
     * RELATIONSHIPS
     */

    public function permissionGroup()
    {
        return $this->hasOne('App\Models\PermissionGroup', 'id', 'permission_group_id');
    }

    
    
    /** 
     * SCOPES
    */
    public function scopeOfPermission($query, $permission)
	{
        if (isset($permission) || $permission!="") {
            return $query->where('permission', '=', $permission);
        }
        return $query;
    }
    
    /** 
     * SCOPES
    */
    public function scopeOfGroupId($query, $groupId)
	{
        if (isset($groupId) || $groupId!="") {
            return $query->where('permission_group_id', '=', $groupId);
        }
        return $query;
    }
    
   
}
