<?php

namespace App\Http\Middleware;

use Closure;

class VerifyPageAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $moduleName, $moduleAccess)
    {
        //dd($moduleName.'-'.$moduleAccess);
        $valid = false;
        $access = [];
        if (session()->has('allUserAccesses')) {
            $access = session('allUserAccesses');
            if ( isset($access[$moduleName]) ) {
                $moduleAccesses = explode("|",$moduleAccess);
                foreach($moduleAccesses as $moduleAccess)
                {
                    if (strpos($access[$moduleName], $moduleAccess) !== false) {
                        $valid=true;
                    }
                }
            }
        }
        if (isset($access['admin']) && strpos($access['admin'], 'super admin access', true)) { 
            $valid = true; 
        }

        if (!$valid) {
            return redirect('/')->with('failed', 'You have no access to that page.');
        }

        return $next($request); 
    }
}
