<?php

namespace App\Exports;

use App\Models\Feedback;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;

class FeedbackExport implements FromQuery, WithHeadings, ShouldAutoSize
{
    use Exportable;

    public function forYear(int $year)
    {
        $this->year = $year;
        
        return $this;
    }

    public function query()
    {
        return Feedback::query()->whereYear('feedbacks.created_at', $this->year)
            ->join('users', 'users.id', '=', 'feedbacks.user_id')
            ->select('system','comment','rate_overall_review','rate_ease_of_use'
            ,'rate_functionalities','users.first_name','users.last_name'
            ,'feedbacks.created_at');
    }

    public function headings(): array
    {
        return ["System", "Comment", "Overall Review", "Ease of Use"
            , "Functionalities","First Name", "Last Name","Date Created"];
    }
}
