<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('cron:downloadPermissionGroups')->dailyAt('01:00');
        $schedule->command('cron:downloadPermissions')->dailyAt('01:30');
        $schedule->command('cron:downloadRoles')->dailyAt('02:00');
        $schedule->command('cron:downloadUsers')->dailyAt('02:30');
        $schedule->command('cron:downloadPermissionRoleAccesses')->dailyAt('03:00');
        $schedule->command('cron:downloadSiteAccess')->dailyAt()->at('03:30');
        $schedule->command('cron:downloadSites')->dailyAt()->at('03:34');

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
