<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\Log;
use App\Models\VideoRecording;
use App\Models\VideoRoom;
use Twilio\Rest\Client;

class GetRecordingStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:getRecordingStatus';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->sid = config('services.twilio.sid');
        $this->token = config('services.twilio.token');
        $this->key = config('services.twilio.key');
        $this->secret = config('services.twilio.secret');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::info('Started Downloading of Video Room Recordings');            
        $recordings = VideoRecording::where('status','!=', 'completed')->get();
        
        foreach ($recordings as $recording) {
            $client = new Client($this->sid, $this->token);
            $composition = $client->video->compositions($recording->sid)
                ->fetch();
            $recording->status = $composition->status;
            $recording->save();
            
        }
        Log::info('Ended Downloading of Video Room Recordings'); 
    }
}
