<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cust_rec', function (Blueprint $table) {
            $table->id();
            $table->integer('cust_rec_id');
            $table->string('areacode')->nullable();
            $table->string('phone')->nullable();
            $table->string('sname');
            $table->text('address');
            $table->string('city');
            $table->string('state');
            $table->string('zip');
            $table->string('zip4');
            $table->string('status');
            $table->string('addi_status');
            $table->string('call_date');
            $table->string('tsr');
            $table->string('attempt_counter');
            $table->text('company');
            $table->string('fax');
            $table->string('annual_sale');
            $table->string('no_of_employee');
            $table->text('title');
            $table->string('sic_code');
            $table->text('sic_description');
            $table->string('naics_code');
            $table->text('naics_description');
            $table->string('callback_name2');
            $table->string('gate_keeper');
            $table->text('email_to');
            $table->string('appt_date');
            $table->string('appt_time');
            $table->string('appt_name');
            $table->string('email_date_sent');
            $table->string('email_type');
            $table->string('acw_actionitems');
            $table->string('acw_conf_dm');
            $table->text('call_notes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cust_rec');
    }
};
