<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cust_log', function (Blueprint $table) {
            $table->id();
            $table->integer('cust_rec_id');
            $table->text('company_id')->nullable();
            $table->text('contact_id')->nullable();
            $table->string('log_date');
            $table->text('log_notes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cust_log');
    }
};
