<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Facades\DB;
use App\Models\CustomerRecord;

class DailyUnload implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */

    protected $callDate;
    protected $collection;
 
    public function __construct($callDate)
    {
        $this->callDate = $callDate;
        $callDate = \DateTime::createFromFormat('m/d/Y', $callDate);

        // Format the date in yyyy-mm-dd format
        $formattedDate = $callDate->format('Y-m-d');
        $collection = DB::select("SELECT *
                        FROM cust_rec
                        WHERE DATE_FORMAT(STR_TO_DATE(call_date, '%m/%d/%Y'), '%Y-%m-%d') = '{$formattedDate}'");
        
        $collection = collect($collection);
        $this->collection = $collection;//CustomerRecord::where('call_date',$this->callDate)->get();
    }

    public function collection()
    {
        return $this->collection;
    }

    public function headings(): array
    {
        if ($this->collection->isEmpty()) {
            return [];
        }

        // Get the keys (column names) of the first item in the collection
        return array_keys((array)$this->collection->first());
    }

    public function store(string $path)
    {
        return $this->download($path);
    }
}
