<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Illuminate\Support\Facades\DB;
use App\Models\CustomerRecord;

class DailyReport implements FromCollection, WithHeadings, WithStrictNullComparison
{
    /**
    * @return \Illuminate\Support\Collection
    */

    protected $callDate;
    protected $collection;
 
    public function __construct($callDate)
    {
        $this->callDate = $callDate;
        $date = date("Y-m-d", strtotime($callDate));

        $results = DB::select("SELECT cs.description,COUNT(cust_rec_id)  AS recordCount 
                    FROM call_statuses cs
                    LEFT JOIN cust_rec c ON c.`status` = cs.first_status_code AND c.addi_status=cs.first_addi_code 
                    AND STR_TO_DATE(call_date, '%m/%d/%Y') = '{$date}'     
                    GROUP BY cs.description ");
        
        $totalDials = DB::select("SELECT COUNT(cust_rec_id)  AS recordCount 
                    FROM call_statuses cs
                    LEFT JOIN cust_rec c ON c.`status` = cs.first_status_code AND c.addi_status=cs.first_addi_code 
                    WHERE STR_TO_DATE(call_date, '%m/%d/%Y') = '{$date}'");

        $totalDials = collect($totalDials);
        $totalDials = $totalDials[0];

        $emailSent = DB::select("SELECT 
                        SUM(CASE WHEN log_notes ='DM-GK Email Sent' THEN 1 ELSE 0 END) AS 'decisionMaker',
                        SUM(CASE WHEN log_notes ='Scheduled Appointment Email Sent' THEN 1 ELSE 0 END) AS 'appointmentEmail',
                        SUM(CASE WHEN log_notes ='Pre-call Email sent' THEN 1 ELSE 0 END) AS 'preCallEmail'
                        FROM cust_log
                        WHERE STR_TO_DATE(log_date, '%m/%d/%Y') = '{$date}'");

        $emailSent = collect($emailSent);
        $emailSent = $emailSent[0];

        $secondTouch = DB::select("SELECT 
                        SUM(CASE WHEN STATUS IN('C','GC','SC') AND acw_actionitems LIKE '%Yes%' THEN 1 ELSE 0 END) AS 'capturedImportantNotes',
                        SUM(CASE WHEN STATUS IN('C','GC','SC') AND acw_conf_dm LIKE '%Yes%' THEN 1 ELSE 0 END) AS 'updatedNewContact',
                        SUM(CASE WHEN STATUS IN('C') AND addi_status = 'SA' THEN 1 ELSE 0 END) AS 'securedAppointment',
                        SUM(CASE WHEN STATUS IN('C') AND addi_status = 'CL' THEN 1 ELSE 0 END) AS 'clientFollowup'
                        FROM cust_rec
                        WHERE STR_TO_DATE(call_date, '%m/%d/%Y') = '{$date}'");
        
        $secondTouch = collect($secondTouch);
        $secondTouch = $secondTouch[0];

        $extraData = [
            ['description' => 'Date', 'recordCount' => $callDate],
            ['description' => 'Recipients Who Clicked:', 'recordCount' => 0],
            ['description' => 'Unsubscribe Count:', 'recordCount' => 0],
            ['description' => 'Information Updated(Second Touch)', 'recordCount' => ''],
            ['description' => 'Captured Important Notes', 'recordCount' => $secondTouch->capturedImportantNotes],
            ['description' => 'Updated New Contact Information', 'recordCount' => $secondTouch->updatedNewContact],
            ['description' => 'Secured an Appointment (SA)', 'recordCount' => $secondTouch->securedAppointment],
            ['description' => 'Total Number of Client Follow-ups (CL)', 'recordCount' => $secondTouch->clientFollowup],
            ['description' => 'Email Sent (Third Touch)', 'recordCount' => ''],
            ['description' => 'Decision/Gate Keeper Maker', 'recordCount' => $emailSent->decisionMaker],
            ['description' => 'Appointment Email', 'recordCount' => $emailSent->appointmentEmail],
            ['description' => 'Pre-call Email', 'recordCount' =>  $emailSent->preCallEmail],
            ['description' => 'Total Dials', 'recordCount' =>  $totalDials->recordCount],
        ];

        array_unshift($results, $extraData);


        $collection = collect($results);

        //dd($collection);

        $this->collection = $collection;
    }

    public function collection()
    {
        return $this->collection;
    }

    public function headings(): array
    {
        return [];
    }

    public function store(string $path)
    {
        return $this->download($path);
    }
}
