<?php

use Illuminate\Http\Request;
use App\Models\User;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::get('videos/test', 'VideoRoomController@smsTest');
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/tokens/create', function (Request $request) {
    $user = User::where('email',$request->email)->first();
    if(isset($user))
    {
        $token = $user->createToken($request->token_name);
        return ['token' => $token->plainTextToken];
    } else {
        return [
            'message' => 'Invalid email',
            'token' => ''];
    }
});

Route::group(['middleware' => ['auth:sanctum']], function (){
    Route::post('/createRoom', 'API\VideoController@createRoom');    
});

Route::group(['middleware' => ['auth:sanctum']], function (){
    Route::post('/createRoomEmail', 'API\VideoController@createRoomEmail');    
});

Route::group(['middleware' => ['auth:sanctum']], function (){
    Route::get('/getShippingInfo', 'API\VideoController@getShippingInfo');    
});

Route::group(['middleware' => ['auth:sanctum']], function (){
    Route::post('/createContact', 'API\VideoController@createContact');    
});