@extends('layouts.app')

@push('style')
    <style>
        #media-div video{
            width: 100%;
        }
        
        .devices {
            max-width: 150px;
            margin-right: 0px;
            display: inline;
        }
    </style>
@endpush

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Vide Management</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/videos">Videos</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Create New Room</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
<form id="frmCreateRoom" name="frmCreateRoom" role="form" action="{{ url("/videos/room/createRoom") }}" enctype="multipart/form-data" method="POST">
    <input type="hidden" id="hostId" name="hostId" />
    <input type="hidden" id="roomId" name="roomId" value="{{$roomId}}">
    <input type="hidden" id="currentParticipantSID" name="currentParticipantSID">

    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12"> 
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Video Room - {{Request::fullUrl()}}</h3>
                </div>
                <div class="card-body">
                    <div id="media-div" class="row"></div>
                    <div id="companyLogo" class="row d-none">
                        <div class="border-radius-xl col-sm-4 rounded-video">
                            <img src="/img/logo.jpg" alt="Covid PCR" width="100%">
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
               
                <div class="card-footer">
                    <div class="row">
                        <div class="col-12">
                            <select id="video-devices" class="form-control devices d-none" placeholder="Select Camera"></select>
                            <input type="button" class="btn btn-warning" name="" id="" value="Switch Camera" onclick="switchCamera();"/>
                            <input type="button" class="btn btn-info" name="hideParticipant" id="hideParticipant" value="Hide Video" onclick="hideVideo();"/>
                            <a href="/videos/room/completeRoom/{{$roomId}}" class="btn btn-danger">End Session</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="{{ config("app.cdn") . "/js/video/index.js" . "?v=" . config("app.version") }}"></script>
    <script src="//sdk.twilio.com/js/video/releases/2.17.1/twilio-video.min.js"></script>

    <script>
        const {connect, createLocalTracks} = Twilio.Video;
    </script>

    <script>
        console.log("participant user");
        createLocalTracks({
            audio: true,
            video: { width: 300 }
        }).then(function(localTracks) {
            
            console.log("===", localTracks);

            navigator.mediaDevices.enumerateDevices()
            .then((mediaDevices) => {
                const devices = mediaDevices.filter(mediaDevice => mediaDevice.kind === 'videoinput')
                localStorage.setItem('videoInputOne', JSON.stringify(devices[0]))
                localStorage.setItem('videoInputTwo', JSON.stringify(devices[(devices.length-1)]))
            });
        
            var localMediaContainer = document.getElementById('media-div');
            const trackContainer = document.createElement('div');
            trackContainer.id = 'localUser';
            trackContainer.className = "col-lg-4 col-md-6 col-sm-6";
            
            localTracks.forEach(function(track) {
                trackContainer.appendChild(track.attach());
                localMediaContainer.appendChild(trackContainer);
            });

            return connect('{{ $accessToken }}', {
                name: '{{ $roomName }}',
                tracks: localTracks,
                video: { width: 300 }
            });
        }).then(function(room) {
            const localParticipant = room.localParticipant;

            const hostId = $('#hostId').val();
            const participantID = $('#currentParticipantSID').val();

            // log room entry
            console.log('Successfully joined a Room: ', room.name);
            console.log(`Connected to the Room as LocalParticipant "${localParticipant.identity}"`);

            if (participantID == "") {
                saveVideoRoomParticipant(localParticipant.identity);
                $('#currentParticipantSID').val(localParticipant.identity);
            }
            
            room.on('participantConnected', participant => {
                Swal.fire({
                    icon: 'info',
                    position: 'top-right',
                    text: `New participant connected`,
                    showConfirmButton: false,
                    timerProgressBar: true,
                    toast: true,
                    timer: 3000
                });

                const trackContainer = document.createElement('div');
                trackContainer.id = participant.identity;
                trackContainer.className = "col-lg-4 col-md-6 col-sm-6";

                // this will update local or agent video feed
                participant.on('trackSubscribed', track => {
                    if (track.kind == 'video') {
                        const participantTrack = $('#'+participant.identity)
                        if (participantTrack.find('video')) {
                            participantTrack.find('video').remove();
                        }
                    }

                    trackContainer.appendChild(track.attach());
                    document.getElementById('media-div').appendChild(trackContainer);
                });
            });

            room.participants.forEach(participant => {
                Swal.fire({
                    icon: 'info',
                    position: 'top-right',
                    text: `New participant connected`,
                    showConfirmButton: false,
                    timerProgressBar: true,
                    toast: true,
                    timer: 3000
                });
                console.log(`Participant "${participant.identity}" is connected to the Room`);

                const trackContainer = document.createElement('div');
                trackContainer.id = participant.identity;
                trackContainer.className = "col-lg-4 col-md-6 col-sm-6";

                // this will update remote or clients video feed
                participant.on('trackSubscribed', track => {
                    if (track.kind == 'video') {
                        const participantTrack = $('#'+participant.identity)
                        if (participantTrack.find('video')) {
                            participantTrack.find('video').remove();
                        }
                    }

                    trackContainer.appendChild(track.attach());
                    document.getElementById('media-div').appendChild(trackContainer);
                });
            });

            room.on('participantDisconnected', participant => {
                console.log(`Participant disconnected: ${participant.identity}`);
                Swal.fire({
                    icon: 'error',
                    position: 'top-right',
                    text: `Participant disconnected`,
                    showConfirmButton: false,
                    timerProgressBar: true,
                    toast: true,
                    timer: 3000
                });
                $('#'+participant.identity).remove();
            });

            gotDevices()
            const select = $('#video-devices');

            select.on('change', function(event) {
                updateVideoDevice(event, room)
            });
        });
    </script>

    <script>
        function gotDevices() {
            const select = document.getElementById('video-devices');

            select.innerHTML = '';
            select.appendChild(document.createElement('option'));
            
            const mediaDevices = [
                JSON.parse(localStorage.getItem('videoInputOne')),
                JSON.parse(localStorage.getItem('videoInputTwo'))
            ]

            let count = 1;
            mediaDevices.forEach((mediaDevice, index) => {
                if (mediaDevice.kind === 'videoinput') {
                    const option = document.createElement('option');
                    option.value = mediaDevice.deviceId;
                    
                    if (index == 0) {
                        option.selected = true;
                    }

                    const label = mediaDevice.label || `Camera ${count  }`;
                    const textNode = document.createTextNode(label);
                    option.appendChild(textNode);
                    select.appendChild(option);
                }
            });
        }

        function updateVideoDevice(event, room) {
            const select = event.target;
            if (select.value !== '') {
                // Detach the local media elements
                room.localParticipant.tracks.forEach(publication => {
                    const attachedElements = publication.track.detach();
                    attachedElements.forEach(element => element.remove());
                });

                //unpublish existing video track
                room.localParticipant.videoTracks.forEach(publication => {
                    publication.track.stop();
                    publication.unpublish();
                });

                Twilio.Video.createLocalVideoTrack({
                    deviceId: { exact: select.value }
                }).then(localVideoTrack => {
                    const trackContainer = document.getElementById('localUser');
                    trackContainer.appendChild(localVideoTrack.attach());

                    return room.localParticipant.publishTrack(localVideoTrack);
                });
            }
        }

        function switchCamera() {
            let select = $('#video-devices');

            const selected = select.find(":selected").val()
            if (selected == "") {
                select.find('option').each(function(index) {
                    const option = $(this).val()
                    if (index == 1) {
                        select.val(option).trigger('change')
                        return;
                    }
                });
            } else {
                select.find('option').each(function(index) {
                    const option = $(this).val()
                    if (selected != "" && selected != option) {
                        select.val(option).trigger('change')
                        return;
                    }
                });
            }
        }
    </script>

    <script>
        window.onload = function(){
    
        var hou = 0;
        var sec = 1;
        setInterval(function(){
        sec--;
        if(sec == 0)
        {
            
            sec = 1;
            if (hou == 0)
            {
                hou--;
                hou = 0;
                checkVideoSession();
                checkVideoStatus();
            }
        }
        },1000);
        }
        
    </script>
@endsection