@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Manage Videos</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Users</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            @if(\App\Models\Permission::canCreate(session('allUserAccesses')['videos']))
            <div style="float:right">
              <a class="btn btn-primary btn-sm" href="/videos/room">  
              <li class= "fa fa-user"></li> Create New Room
              </a>
            </div>
            @endif
        </div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <table id="videosTable" class="table table-striped projects">
                    <thead>
                        <tr>
                            <th style="width: 1%">
                                #
                            </th>
                            {{-- <th style="width: 20%">
                                Room Name
                            </th> --}}
                            <th style="width: 30%">
                                Room ID
                            </th>
                            <th>
                                Mobile Number
                            </th>
                            <th>
                                Create Date
                            </th>
                            <th style="width: 8%" class="text-center">
                                Status
                            </th>
                            <th>
                                Files
                            </th>
                            <th style="width: 20%">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->
@endsection
@include('incs.datatable')
@section('script')
<script src="{{ config("app.cdn") . "/js/video/index.js" . "?v=" . config("app.version") }}"></script>
<script>
    $('#videosTable').DataTable( {
    order: [[ 0, 'desc' ], [ 1, 'asc' ]]
} );
  getVideos();
</script>
@endsection
