@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Reports</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Session Report</li>
                </ol>
	        </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header border-0">Report Filter</div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <form>
                    <div class="row">
                        <div class="col-12 col-lg-5 col-xl-5">
                            <div class="form-group">
                                <input type="date" class="form-control" name="datefrom" id ="datefrom" value="">
                            </div>
                        </div>
                        <div class="col-12 col-lg-5 col-xl-5">
                            <div class="form-group">
                                <input type="date" class="form-control" name="dateto" id ="dateto" value="">
                            </div>
                        </div>
                        <div class="col-12 col-lg-2 col-xl-2">
                            <button type="button" class="btn btn-success btn-block waves-effect waves-light" onclick="javascript: getSessionReport()">APPLY FILTER</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header border-0 text-right">
            <form action="/report/export" method="POST">
                @csrf
                <input type="hidden" name="hiddenDateTo" id ="hiddenDateTo" value="">
                <input type="hidden" name="hiddenDateFrom" id ="hiddenDateFrom" value="">
                <button class="btn btn-primary waves-effect waves-light mb-3">Unload Data</button>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <table id="sessionTable" class="table table-striped projects">
                    <thead>
                        <tr>
                            <th style="width: 1%">
                                #
                            </th>
                            <th style="width: 20%">
                                Room
                            </th>
                            <th style="width: 30%">
                                Mobile/Email
                            </th>
                            <th>
                                Session Start
                            </th>
                            <th>
                                Session End
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->

</section>
<!-- /.content -->

@endsection
@include('incs.datatable')
@section('script')
<script src="{{ config("app.cdn") . "/js/report/index.js" . "?v=" . config("app.version") }}"></script>
<script>
    getSessionReport();

    $('#datefrom').on('change', function(e) {
        $('#hiddenDateFrom').val($(this).val())
    })
    $('#dateto').on('change', function(e) {
        $('#hiddenDateTo').val($(this).val())
    })
</script>
@endsection
