@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Feedback Report</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/report/feeback/">Feedback</a></li>
                    <li class="breadcrumb-item active">View Report</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
<form id="frmFeedbackReport" name="frmFeedbackReport" role="form" action="{{ url("/report/feedbackExport") }}"
    enctype="multipart/form-data" method="POST">
    {{ csrf_field() }}
    <input type = "hidden" id="access" name="access"/>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Report</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                            title="Collapse">
                            <i class="fas fa-minus"></i></button>
                    </div>
                </div>
                <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label for="inputName">Select Year</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                      <span class="input-group-text"><i class="far fa-calendar-alt"></i></span>
                                    </div>
                                    <input id="year" name="year" type="text" class="form-control" data-inputmask-alias="datetime" data-inputmask-inputformat="yyyy" data-mask>
                                  </div>
                            </div>
                        </div>
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <a href="/report" class="btn btn-secondary">Cancel</a>
            <input type="submit" value="Export to Excel" class="btn btn-success float-right">
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<!-- InputMask -->
<script src="{{ asset('assets/plugins/moment/moment.min.js')}}"></script>
<script src="{{ asset('assets/plugins/inputmask/min/jquery.inputmask.bundle.min.js')}}"></script>
<script>
    $('#year').inputmask('yyyy', { 'placeholder': 'yyyy' })
    $('[data-mask]').inputmask()
</script>
@endsection