@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Add New Dropbox Account</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/dropbox/">Dropbox Accounts</a></li>
                    <li class="breadcrumb-item active">Add Account</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
<form id="frmUpdateDropboxAccount" name="frmUpdateDropboxAccount" role="form" action="{{ url("/dropbox/$dropboxAccount->id/update") }}"
    enctype="multipart/form-data" method="POST">
    <input type="hidden" id="_method" name="_method" value="PUT" />
    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Account Details</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                            title="Collapse">
                            <i class="fas fa-minus"></i></button>
                    </div>
                </div>
                <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Name</label>
                                <input type="text" id="name" name="name" class="form-control"
                                       value="{{$dropboxAccount->name}}" disabled>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Description</label>
                                <input type="text" id="description" name="description" class="form-control"
                                  value="{{$dropboxAccount->description}}" disabled>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">App Key</label>
                                <input type="text" id="appKey" name="appKey" class="form-control"
                                  value="{{$dropboxAccount->app_key}}" disabled>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">App Secret</label>
                                <input type="text" id="appSecret" name="appSecret" class="form-control"
                                  value="{{$dropboxAccount->app_secret}}" disabled>
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Access Token</label>
                                <input type="text" id="accessToken" name="accessToken" class="form-control"
                                  value="{{$dropboxAccount->access_token}}" disabled>
                            </div>
                        </div>
                      
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection