@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Dropbox Accounts</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item active">Dropbox Accounts</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Dropbox Files</h3>
            <a class="float-right btn btn-info btn-small" href="#" onclick="uploadFile({{$id}},'{{$path}}');">Upload File</a>
            <a class="float-right btn btn-success btn-small" href="#" onclick="createDropboxFolder({{$id}},'{{$path}}');">Create Folder</a>
            @if($path!="")
                <a class="float-right btn btn-primary btn-small" href="javascript:history.back()">Go Back</a>
            @endif
        </div>
        <div class="card-body p-0">
            <div class="container-fluid">
                <div id="divFiles" name= "divFiles" class="row">
                @foreach($files as $file)
                    <div class="col-md-3">
                        <div class="info-box {{$file['.tag'] === "folder" ? "bg-info" : "bg-success"}}">
                        <span class="info-box-icon"><i class="far fa-{{$file['.tag']}}"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">{{$file['name']}}</span>
                            <span class="info-box-number">{{$file['.tag']}}</span>

                            <span class="progress-description">
                                @if($file['.tag'] === "folder")
                                    <a href="/dropbox/{{$id}}/files?path={{urlencode($file['path_lower'])}}">
                                    <li class="fa fa-folder" title="Open" style="color: crimson"></li>
                                    </a>
                                @else
                                    <a href="#" onclick="downloadDropboxFile({{$id}},'{{$file['path_display']}}')">
                                    <li class="fa fa-download" style="color: crimson"></li></a>
                                @endif
                                <a href="#" onclick="shareFile('{{$file['name']}}','{{$file['path_lower']}}','{{$file['.tag']}}','{{$file['name']}}');">
                                    <li class="fa fa-share" title="Share" style="color: rgba(73, 1, 17, 0.822)"></li>
                                </a> 
                            </span>
                        </div>
                        <!-- /.info-box-content -->
                        </div>
                        <!-- /.info-box -->
                    </div>
                @endforeach
                </div>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <!-- /.card -->
    <div class="modal fade" id="modal-dropbox-share">
        <form id="frmShareDropboxAccountAccess" name="frmShareDropboxAccountAccess" 
            role="form" action="{{ url("/dropbox/$id/shareAccess") }}" 
            enctype="multipart/form-data" method="POST">
            {{ csrf_field() }}
        <input type="hidden" id="dropboxId" name="dropboxId" value={{$id}} />
        <input type="hidden" id="userId" name="userId" />
        <input type="hidden" id="sharedFileName" name="sharedFileName" />
        <input type="hidden" id="sharedFile" name="sharedFile" />
        <input type="hidden" id="sharedFileType" name="sharedFileType" />
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Share File</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p>File/Folder Name: <label id="name"></label></p>
              <p>Share access to: </p>
              <div class="row">
                <div class="col-sm-6">
                    @foreach($roles as $role)
                        <div class="col-sm-4">
                            <input data-toggle="tooltip" data-html="true" type="checkbox" class="roles-cb"
                                id="{{$role->id}}" value="{{$role->id}}"//>
                            <label>{{$role->name}}</label>    
                        </div>
                    @endforeach
                </div>
                <div id="divUsers" class="col-sm-6">

                </div>
              </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <input type="submit" id="btnShareAccess" class="btn btn-primary" value="Save Changes">
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        </form>
        <!-- /.modal-dialog -->
      </div>

      <div class="modal fade" id="modal-dropbox-upload-file">
        <form id="frmUploadFile" name="frmUploadFile" 
            role="form" action="{{ url("/dropbox/$id/uploadFile") }}" 
            enctype="multipart/form-data" method="POST">
            {{ csrf_field() }}
        <input type="hidden" id="uploadFileDropboxId" name="uploadFileDropboxId" value={{$id}} />
        <input type="hidden" id="uploadFilePath" name="uploadFilePath" />
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Upload File</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="form-group col-md-6">
                    <input type="file" id="fileName" name="fileName" />
                </div>
              </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <input type="submit" id="btnUploadFile" class="btn btn-primary" value="Upload">
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        </form>
        <!-- /.modal-dialog -->
      </div>

      <div class="modal fade" id="modal-dropbox-create-folder">
        <form id="frmCreateDropboxFolder" name="frmCreateDropboxFolder" 
            role="form" action="{{ url("/dropbox/$id/createFolder") }}" 
            enctype="multipart/form-data" method="POST">
            {{ csrf_field() }}
        <input type="hidden" id="dropboxId" name="dropboxId" value={{$id}} />
        <input type="hidden" id="userId" name="userId" />
        <input type="hidden" id="path" name="path" />
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Create Directory</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="form-group col-md-6">
                    <label for="inputName">Folder Name:</label>
                    <input type="text" id="folderName" name="folderName" class="form-control"
                           value="{{ old('folderName') }}">
                </div>
              </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <input type="submit" id="btnCreateFolder" class="btn btn-primary" value="Create">
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        </form>
        <!-- /.modal-dialog -->
      </div>

</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ asset('assets/plugins/select2/js/select2.full.min.js') }}"></script>
<script src="{{ config("app.cdn") . "/js/dropbox/list.js" . "?v=" . config("app.version") }}"></script>
@endsection
