@extends('layouts.app')
@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Add New Dropbox Account</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item"><a href="/dropbox/">Dropbox Accounts</a></li>
                    <li class="breadcrumb-item active">Add Account</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
<form id="frmCreateDropboxAccount" name="frmCreateDropboxAccount" role="form" action="{{ url("/dropbox") }}"
    enctype="multipart/form-data" method="POST">
    {{ csrf_field() }}
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">Account Details</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                            title="Collapse">
                            <i class="fas fa-minus"></i></button>
                    </div>
                </div>
                <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Name</label>
                                <input type="text" id="name" name="name" class="form-control"
                                       value="{{ old('name') }}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">Description</label>
                                <input type="text" id="description" name="description" class="form-control"
                                  value="{{ old('description') }}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">App Key</label>
                                <input type="text" id="appKey" name="appKey" class="form-control"
                                  value="{{ old('appKey') }}">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inputName">App Secret</label>
                                <input type="text" id="appSecret" name="appSecret" class="form-control"
                                  value="{{ old('appSecret') }}">
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputName">Access Token</label>
                                <input type="text" id="accessToken" name="accessToken" class="form-control"
                                  value="{{ old('accessToken') }}">
                            </div>
                        </div>
                      
                </div>
                <!-- /.card-body -->
               
            </div>
            <!-- /.card -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <a href="/dropbox" class="btn btn-secondary">Cancel</a>
            <input type="submit" value="Create new account" class="btn btn-success float-right">
        </div>
    </div>
    </form>
</section>
<!-- /.content -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/create.js" . "?v=" . config("app.version") }}"></script>
@endsection