<!-- START card -->
<div class="card card-transparent">
    <div class="card-header  ">
        <div class="card-title">Pages Cards
        </div>
    </div>
    <div class="m-0 row card-body">
        <div class="col-lg-12 sm-no-padding">
            <div class="card card-transparent">
                <div class="card-body no-padding">
                    <div id="card-advance" class="card card-default">
                        <div class="card-header  ">
                            <div class="card-title">DELIVERY CONFIRMATION
                            </div>
                            <div class="card-controls">
                            </div>
                        </div>
                        <div class="card-body">
                            <h3>
                                <span class="semi-bold">UNCONFIRMED</span> SHIPPING UNITS (LAST 12 MONTHS)</h3>
                            <br>
                            <div>
                                <div id="chartdiv" style="width=100%;height: 500px;" ></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('incs.amcharts');
<script>
    am4core.ready(function() {
    
    // Themes begin
    am4core.useTheme(am4themes_animated);
    // Themes end
    
    var chart = am4core.create("chartdiv", am4charts.XYChart);
    chart.hiddenState.properties.opacity = 0; // this creates initial fade-in
    
    //data
    let url  = '/home/unconfirmed'
    axios.get(url, {
       
    })
    .then(function (response) {
        chart.data = response.data;
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })
    
    var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
    categoryAxis.renderer.grid.template.location = 0;
    categoryAxis.dataFields.category = "site_code";
    categoryAxis.renderer.minGridDistance = 40;
    categoryAxis.fontSize = 11;
    
    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

    valueAxis.renderer.minGridDistance = 30;
    // axis break
    var axisBreak = valueAxis.axisBreaks.create();
    axisBreak.startValue = 2100;
    axisBreak.endValue = 22900;
    //axisBreak.breakSize = 0.005;
    
    // fixed axis break
    var d = (axisBreak.endValue - axisBreak.startValue) / (valueAxis.max - valueAxis.min);
    axisBreak.breakSize = 0.05 * (1 - d) / d; // 0.05 means that the break will take 5% of the total value axis height
    
    // make break expand on hover
    var hoverState = axisBreak.states.create("hover");
    hoverState.properties.breakSize = 1;
    hoverState.properties.opacity = 0.1;
    hoverState.transitionDuration = 1500;
    
    axisBreak.defaultState.transitionDuration = 1000;
    
    var series = chart.series.push(new am4charts.ColumnSeries());
    series.dataFields.categoryX = "site_code";
    series.dataFields.valueY = "total";
    series.columns.template.tooltipText = "{valueY.value}";
    series.columns.template.tooltipY = 0;
    series.columns.template.strokeOpacity = 0;
    
    // as by default columns of the same series are of the same color, we add adapter which takes colors from chart.colors color set
    series.columns.template.adapter.add("fill", function(fill, target) {
      return chart.colors.getIndex(target.dataItem.index);
    });
    
    }); // end am4core.ready()
    </script>