@extends('layouts.app')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Calendar</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="/">Home</a></li>
                    <li class="breadcrumb-item active">Calendar  </li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <!-- /.col -->
        <div class="col-md-12">
          <div class="card card-primary">
            <div class="card-body p-0">
              <!-- THE CALENDAR -->
              <div id="calendar"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div><!-- /.container-fluid -->
  </section>
  <div class="modal fade" id="modal-calendar-activity">
    <form id="frmCalendar" name="frmCalendar" 
        role="form">
        {{ csrf_field() }}
    <input type="hidden" id="userId" name="userId" value="{!! auth()->user()->id !!}"/>
    <input type="hidden" id="sharedAccessId" name="sharedAccessId" value=""/>
    <input type="hidden" id="calendarId" name="calendarId" />
    <input type="hidden" id="modalCancel" name="modalCancel" />
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title"  id="modal-title">Create Calendar Activity</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="form-group col-md-12">
                <label for="inputName">Title :</label>
                <input type="text" id="calendarTitle" name="calendarTitle" class="form-control"
                       value="{{ old('calendarTitle') }}">
            </div>
            <div class="form-group col-md-12">
                <label for="inputName">Description :</label>
                <textarea id="calendarDescription" name="calendarDescription" class="form-control" rows="6">
                 {{ old('calendarDescription') }}
                </textarea>
            </div>
            <div class="form-group col-md-6">
                <label for="inputName">Activity Dates :</label>
                <input type="text" id="calendarActivityDateTime" name="calendarActivityDateTime" class="form-control"
                       value="{{ old('calendarActivityDateTime') }}">
            </div>
            <div class="form-group col-md-6">
                <label>Event Color:</label>
                <div class="input-group my-colorpicker">
                  <input type="text" class="form-control" id="calendarColor" name="calendarColor">

                  <div class="input-group-append">
                    <span class="input-group-text"><i class="fas fa-square"></i></span>
                  </div>
                </div>
            </div>
            <div class="col-sm-6">
              <!-- radio -->
              <div class="form-group clearfix">
                <label for="inputName">Select Privacy: </label>
                <br>
                <div class="classRadio icheck-success d-inline">
                  <input type="radio" name="r3" id="isPublic">
                  <label for="isPublic">
                    Public
                  </label>
                </div>
                <div class="classRadio icheck-success d-inline">
                  <input type="radio" name="r3" checked id="isPrivate">
                  <label for="isPrivate">
                    Private
                  </label>
                </div>
              </div>
            </div>
            <div id="divIsPrivate" class="col-sm-12">
              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group clearfix">
                    <label for="inputName">Select Roles: </label>
                    <br>
                    @foreach($roles as $role)
                        <div class="col-sm-4 icheck-danger d-inline">
                            <input data-toggle="tooltip" data-html="true" type="checkbox" class="roles-cb"
                                id="{{$role->id}}" value="{{$role->id}}" />
                            <label for="{{$role->id}}">{{$role->name}}</label>    
                        </div>
                    @endforeach
                  </div>
                </div>
                <div class="col-sm-6">
                  <label for="inputName">Select Users: </label>
                  <div id="divUsers" class="col-sm-12">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <div id="divDelete">
          <input type="button" id="btnDeleteCalendar" class="btn btn-danger" value="Delete">
          </div>
          <div id="divUpdate">
          <input type="button" id="btnUpdateCalendar" class="btn btn-primary" value="Update">
          </div>
          <div id="divCreate">
          <input type="button" id="btnSubmitCalendar" class="btn btn-primary" value="Save">
          </div>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    </form>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.content -->
@endsection
@include('incs.calendar')
@include('incs.daterangepicker')
@include('incs.icheck')
@section('script')
<script src="{{ config("app.cdn") . "/js/calendar/index.js" . "?v=" . config("app.version") }}"></script>
<script>
  $(function () {
    $('.my-colorpicker').colorpicker()
    $('.my-colorpicker').on('colorpickerChange', function(event) {
      $('.my-colorpicker .fa-square').css('color', event.color.toString());
    });
  })
</script>
@endsection
