@extends('layouts.app')
@section('content')
<!-- Main content -->
 <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-3">

          <!-- Profile Image -->
          <div class="card card-primary card-outline">
            <div class="card-body box-profile">
              <div class="text-center">
                <img class="profile-user-img img-fluid img-circle"
                     src="../../dist/img/user4-128x128.jpg"
                     alt="User profile picture"
                     onerror="this.onerror=null; this.src='{{asset('assets/img/logo.jpg')}}'">
              </div>

              <h3 class="profile-username text-center">{{$user->first_name}} {{$user->last_name}} </h3>

              <p class="text-muted text-center">{{$user->job_title}}</p>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->

          <!-- About Me Box -->
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">About Me</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <strong><i class="fas fa-book mr-1"></i> Education</strong>

              <p class="text-muted">
                {{$user->education}}
              </p>

              <hr>

              <strong><i class="fas fa-map-marker-alt mr-1"></i> Location</strong>

              <p class="text-muted">{{$user->location}}</p>

              <hr>

              <strong><i class="fas fa-pencil-alt mr-1"></i> Skills</strong>

              <p class="text-muted">
                <span class="tag tag-danger">{{$user->skills}}</span>
              </p>

            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
        <div class="col-md-9">
          <div class="card">
            <div class="card-header p-2">
              <ul class="nav nav-pills">
                <li class="nav-item"><a class="nav-link active"  href="#settings" data-toggle="tab">Change password</a></li>
                <li class="nav-item"><a class="nav-link"  href="#profile" data-toggle="tab">Profile</a></li>
              </ul>
            </div><!-- /.card-header -->
            <div class="card-body">
              <div class="tab-content">
                <div class="tab-pane active" id="settings">
                    <form id="frmUpdatePassword" name="frmUpdatePassword" role="form" action="{{ url("/admin/users/updatePassword") }}"
                    enctype="multipart/form-data" method="POST">
                    <input type="hidden" id="_method" name="_method" value="PUT" />
                    {{ csrf_field() }}
                    <div class="form-group row">
                      <label for="inputName" class="col-sm-2 col-form-label">Current Password:</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" id="current_password"  name="current_password" placeholder="Current Password" value="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputName" class="col-sm-2 col-form-label">New Password:</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" id="password"  name="password" placeholder="New Password" value="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputName" class="col-sm-2 col-form-label">Confirm New Password:</label>
                      <div class="col-sm-10">
                        <input type="password" class="form-control" id="password_confirmation"  name="password_confirmation" placeholder="Confirm New Password" value="">
                      </div>
                    </div>
                    <div class="form-group row">
                        <div class="offset-sm-2 col-sm-10">
                            <button type="submit" class="btn btn-danger">Update</button>
                        </div>
                    </div>
                    </form>
                </div>
                <div class="tab-pane" id="profile">
                <form id="frmUpdateProfile" name="frmUpdateProfile" role="form" action="{{ url("/admin/users/updateProfile") }}"
                    enctype="multipart/form-data" method="POST">
                    <input type="hidden" id="_method" name="_method" value="PUT" />
                    {{ csrf_field() }}
                    <div class="form-group row">
                      <label for="inputName" class="col-sm-2 col-form-label">First Name</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="first_name"  name="first_name" placeholder="First Name" value="{{$user->first_name}}">
                      </div>
                    </div>
                    <div class="form-group row">
                        <label for="inputName2" class="col-sm-2 col-form-label">Last Name</label>
                        <div class="col-sm-10">
                          <input type="text" class="form-control" id="last_name" name="last_name" placeholder="Last Name" value="{{$user->last_name}}">
                        </div>
                      </div>
                    <div class="form-group row">
                      <label for="inputEmail" class="col-sm-2 col-form-label">Email</label>
                      <div class="col-sm-10">
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email" value="{{$user->email}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputEmail" class="col-sm-2 col-form-label">Mobile Number</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="mobile_number" name="mobile_number" placeholder="Mobile Number" value="{{$user->mobile_number}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputExperience" class="col-sm-2 col-form-label">Experience</label>
                      <div class="col-sm-10">
                        <textarea class="form-control" id="experience" name="experience" placeholder="Experience">{{$user->experience}}</textarea>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputSkills" class="col-sm-2 col-form-label">Skills</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="skills" name="skills" placeholder="Skills" value="{{$user->skills}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputSkills" class="col-sm-2 col-form-label">Location</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="location" name="location" placeholder="Location" value="{{$user->location}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputSkills" class="col-sm-2 col-form-label">Education</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="education" name="education" placeholder="Education" value="{{$user->education}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="inputSkills" class="col-sm-2 col-form-label">Job Title</label>
                      <div class="col-sm-10">
                        <input type="text" class="form-control" id="job_title" name="job_title" placeholder="Job Title" value="{{$user->job_title}}">
                      </div>
                    </div>
                    <div class="form-group row">
                      <div class="offset-sm-2 col-sm-10">
                        <button type="submit" class="btn btn-danger">Update</button>
                      </div>
                    </div>
                  </form>
                </div>
                <!-- /.tab-pane -->
              </div>
              <!-- /.tab-content -->
            </div><!-- /.card-body -->
          </div>
          <!-- /.nav-tabs-custom -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div><!-- /.container-fluid -->
  </section>
  <!-- /.content -->
</div>
<!-- /.content-wrapper -->
@endsection
@section('script')
<script src="{{ config("app.cdn") . "/js/admin/user/index.js" . "?v=" . config("app.version") }}"></script>
<script>
</script>
@endsection