import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

function getVideos() {

    showLoading('Loading Rooms...', 'Please wait while we load the data')
    let url  = '/videos/getData'
    
    require('axios-debug-log')
    axios.get(url, {
        params: {
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        closeLoading()
        $('#videosTable').dataTable().fnDestroy();
        var oTable = $('#videosTable').dataTable({
            "bRetrieve": true,
            "order": [[ 0, 'desc' ], [ 1, 'asc' ]]
        });
        oTable.fnClearTable();
        if (Object.keys(response.data).length > 0)
        {
            oTable.fnAddData(response.data);
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function checkVideoSession()
{
    let url  = '/videos/checkRoomSession'
    var roomId = $('#roomId').val();
    axios.get(url, {
        params: {
            'roomId' : roomId,
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        if (Object.keys(response.data).length > 0)
        {
            if(response.data == 'completed')
            {
                alert('Session ended.')
                window.location = '/videos/thanks';
            }
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })
}

function saveVideoRoomParticipant(participantSID)
{
    let url  = '/videos/storeVideoParticipant'
    var roomId = $('#roomId').val();
    axios.get(url, {
        params: {
            'roomId' : roomId,
            'participantSID' : participantSID,
        }
    })
    .then(function (response) {
        console.log('Response:', response);
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })
}

function hideVideo()
{
    let url  = '/videos/hideVideo'
    var roomId = $('#roomId').val();
    var participantSID = $('#currentParticipantSID').val();
    var participantStatus="in-progress";
    if($("#hideParticipant").val()=="Hide Video")
    {
        participantStatus = "hidden";
    } 
    axios.get(url, {
        params: {
            'roomId' : roomId,
            'participantSID' : participantSID,
            'participantStatus' : participantStatus,
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        if($("#hideParticipant").val()=="Hide Video")
        {
            $("#hideParticipant").attr('value', 'Show Video');
        } else {
            $("#hideParticipant").attr('value', 'Hide Video');
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })
}

function checkVideoStatus()
{
    let url  = '/videos/checkVideoStatus'
    var roomId = $('#roomId').val();
    var participantSID = $('#currentParticipantSID').val();
    axios.get(url, {
        params: {
            'roomId' : roomId,
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        $.each(response.data , function(index, item) { 
            if(item.status=="hidden")
            {
                if (typeof item.participantSID != "undefined") {
                    $('#img-'+item.participantSID).attr('hidden',false);
                    $('#'+item.participantSID).attr('hidden',true);   
                }
            } else {
                if (typeof item.participantSID != "undefined") {
                    $('#img-'+item.participantSID).attr('hidden',true);
                    $('#'+item.participantSID).attr('hidden',false);
                }
            }
        });
    })
    .catch(function (error) {

    })
}

window.getVideos = getVideos;
window.checkVideoSession = checkVideoSession;
window.saveVideoRoomParticipant = saveVideoRoomParticipant;
window.hideVideo = hideVideo;
window.checkVideoStatus = checkVideoStatus;