import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

function getSessionReport() {

    showLoading('Loading Session Report Data...', 'Please wait while we load the data')
    let url  = '/report/getSessionReport'
    
    let datefrom = $('#datefrom').val()
    let dateto = $('#dateto').val()

    if (datefrom == "" && dateto == "") {
        datefrom = new Date()
        dateto = new Date()
    }

    require('axios-debug-log')
    axios.get(url, {
        params: {
            datefrom: datefrom,
            dateto: dateto
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        closeLoading()
        $('#sessionTable').dataTable().fnDestroy();
        var oTable = $('#sessionTable').dataTable({
            "bRetrieve": true
        });
        oTable.fnClearTable();
        if (Object.keys(response.data).length > 0)
        {
            oTable.fnAddData(response.data);
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

window.getSessionReport = getSessionReport;