

import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");
$('.select2').select2();

$( document ).ready(function() {
    $(".roles-cb").change(function() {
        callGetUsersByRoleId();    
    });

    $("#btnShareAccess").click(function() {
        var access='';
        $('.users-cb:checkbox:checked').each(function () {
             access = access +  $(this).val() + ",";
        });
        if (access !="")
        {
            $("#userId").val(access);
        } else {
            showPrompt('Share Dropbox Access',
            'Please select at lease one user') 
            return false;  
        }
    });

    $("#btnCreateFolder").click(function() {
        if ($('#folderName').val() !="")
        {
            
        } else {
            showPrompt('Create Dropbox Folder',
            'Please enter folder name') 
            return false;  
        }
    });

    $("#btnUploadFile").click(function() {
        if( document.getElementById("fileName").files.length == 0 ){
            showPrompt('Upload Dropbox File',
            'Please select file') 
            return false;  
        } else {
            showLoading('Uploading file...', 'Please wait')
        }
    });
});

function downloadDropboxFile(id, filename) {

    showLoading('Loading Dropbox Accounts...', 'Please wait while we load the data')
    let url  = '/dropbox/download'
    
    require('axios-debug-log')
    let formData = new FormData();
    formData.append('id', id);
    formData.append('filename',  filename);
    const config = {
        headers: { 
            'content-type': 'multipart/form-data',
            'X-Requested-With' : 'XMLHttpRequest'
        } 
    }
    axios.post(url, formData)
    .then(function (response) {
        console.log('Response:', response);
        if(response.data.message=="Success")
        {
            window.open(response.data.link);
        } else {
            showPrompt('Something went wrong',
            'There was an error processing you request, Please try again.')
        }
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function shareFile(filename, path, fileType, fileName)
{
    $('#name').html(filename);
    $('#sharedFile').val(path);
    $('#sharedFileType').val(fileType);
    $('#sharedFileName').val(fileName);
    $(".roles-cb").prop("checked", false);
    getRoleUsers($('#dropboxId').val(),path);

    $('#modal-dropbox-share').modal('show');
}

function createDropboxFolder(id, path)
{
    $('#path').val(path);
    $('#modal-dropbox-create-folder').modal('show');
}

function uploadFile(id, path)
{
    $('#uploadFilePath').val(path);
    $('#modal-dropbox-upload-file').modal('show');
}

function getUsersByRoleId(roleId,isCheck=true) {

    showLoading('Loading Users...', 'Please wait while we load the data')
    let url  = '/dropbox/getUsersByRole'
    require('axios-debug-log')
    axios.get(url, {
        params: {
            'id' : roleId
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        for (var i = 0; i < response.data.length; i++) {

            var checkbox =  $(document.createElement("input")).attr({
                id:  'user-'+response.data[i].id,
                name:  response.data[i].last_name + ', ' + response.data[i].first_name,
                value: response.data[i].id,
                type:  'checkbox',
                class: 'users-cb',
                checked: isCheck
       })

        var label =  '<label>'+response.data[i].last_name + ', ' + response.data[i].first_name+'</label><br>';
        $("#divUsers").append(checkbox);
        $("#divUsers").append(label);

  
        }
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function getRoleUsers(accountId, sharedPath) {

    showLoading('Loading Role Users...', 'Please wait while we load the data')
    let url  = '/dropbox/getSharedRolesAndUser'
    require('axios-debug-log')
    axios.get(url, {
        params: {
            'id' : accountId,
            'path' : sharedPath
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        var ids="";
        for (var i = 0; i < response.data.length; i++) {
            $("#" + response.data[i].role_id).prop('checked', true);
        }
        callGetUsersByRoleId(false);
        setTimeout(function() { 
            for (var i = 0; i < response.data.length; i++) {
                $("#user-" + response.data[i].shared_user_id).prop('checked', true);
            }
        }, 1000);
        closeLoading()
        
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

function callGetUsersByRoleId(isCheck=true)
{
    var access='';
    $('.roles-cb:checkbox:checked').each(function () {
            access = access +  $(this).val() + ",";
    });
    $("#divUsers").empty();
    if (access != '')
    {
        getUsersByRoleId(access,isCheck);
    }
}

window.downloadDropboxFile = downloadDropboxFile;
window.shareFile = shareFile;
window.getUsersByRoleId = getUsersByRoleId;
window.getRoleUsers = getRoleUsers;
window.callGetUsersByRoleId = callGetUsersByRoleId;
window.createDropboxFolder = createDropboxFolder;
window.uploadFile = uploadFile;