import swal from "sweetalert2";



// Sweet Alert Codes 
function showLoading(title, text) {
    swal.fire({
        title: title,
        text: text,
        showConfirmButton: false,
        allowOutsideClick: false,
        position: "center"
    })
}

function closeLoading() {
    swal.close()
}

function showPrompt(title, html) {
    swal.fire({
        title: title,
        html: html,
        showConfirmButton: true,
        allowOutsideClick: false,
        position: "center"
    })
}

function validateIntKeyPress(el) {
    var v = parseFloat(el.value);
    el.value = (isNaN(v)) ? '' : v.toFixed(0);
}

function validateFloatKeyPress(el) {
    var v = parseFloat(el.value);
    el.value = (isNaN(v)) ? '' : v.toFixed(2);
}

function phonenumber(inputtxt)
{
  var phoneno = /^[\+]?[(]?[0-9]{3}[)]?[-\s\.]?[0-9]{3}[-\s\.]?[0-9]{4,6}$/im;
  if(inputtxt.value.match(phoneno))
     {
	   return true;
	 }
   else
     {
       showPrompt('Users','Please input valid phone number');
       inputtxt.value = '';
	   return false;
     }
}

function isNumber(inputtxt)
{
  var phoneno = /^\d+$/;
  if(inputtxt.value.match(phoneno))
  {
	   return true;
	}   else {
       showPrompt('StratVideo','Please input valid phone number.');
       inputtxt.value = '';
	   return false;
     }
}

function isValidEmail(inputtxt)
{
  var testEmail = /^[A-Z0-9._%+-]+@([A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
  if (testEmail.test(inputtxt))
  {
    return true;  
  } else {
    showPrompt('StratVideo','Please input email address');
    inputtxt.value = '';
    return false;  
  }
}

window.showLoading = showLoading;
window.closeLoading = closeLoading;
window.showPrompt = showPrompt;
window.validateIntKeyPress = validateIntKeyPress;
window.validateFloatKeyPress = validateFloatKeyPress;
window.phonenumber = phonenumber;
window.isNumber = isNumber;
window.isValidEmail = isValidEmail;