import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

function getUsers() {

    showLoading('Loading Users...', 'Please wait while we load the data')
    let url  = '/admin/users/getData'
    
    require('axios-debug-log')
    axios.get(url, {
        params: {
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        closeLoading()
        $('#usersTable').dataTable().fnDestroy();
        var oTable = $('#usersTable').dataTable({
            "bRetrieve": true
        });
        oTable.fnClearTable();
        if (Object.keys(response.data).length > 0)
        {
            oTable.fnAddData(response.data);
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

window.getUsers = getUsers;