
import swal from "sweetalert2";
import axios from "axios";

let appUrl = document.querySelector("#ctx").getAttribute("content");

function getRoles() {

    showLoading('Loading Roles...', 'Please wait while we load the data')
    let url  = '/admin/roles/getData'
    
    require('axios-debug-log')
    axios.get(url, {
        params: {
        }
    })
    .then(function (response) {
        console.log('Response:', response);
        closeLoading()
        $('#rolesTable').dataTable().fnDestroy();
        var oTable = $('#rolesTable').dataTable({
            "bRetrieve": true
        });
        oTable.fnClearTable();
        if (Object.keys(response.data).length > 0)
        {
            oTable.fnAddData(response.data);
        }
    })
    .catch(function (error) {
        showPrompt('Something went wrong',
            'There was an error processing you request, if you believe\
                this is a bug, please contact our team')
        closeLoading()
    })

}

window.getRoles = getRoles;